// EDD file for CFW11 with Anybus
// File name:	CFW11_Anybus_Vars.inc
// Date:		31/8/2007
// Firmware Version:	1,10

VARIABLE P0012
{
	LABEL "P0012 DI8 to DI1 Status|de|P0012 DI8...DI1 Status|es|P0012 Estado DI8...DI1";
	CLASS CONTAINED;
	TYPE BIT_ENUMERATED(2)
	{
		{ 0x01, "DI1" },
		{ 0x02, "DI2" },
		{ 0x04, "DI3" },
		{ 0x08, "DI4" },
		{ 0x10, "DI5" },
		{ 0x20, "DI6" },
		{ 0x40, "DI7", [DI_HELP] },
		{ 0x80, "DI8", [DI_HELP] }
	}
	HANDLING READ;
}

COMMAND READ_P0012
{
	SLOT 0;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0012 }
	}
}

VARIABLE P0013
{
	LABEL "P0013 DO5 to DO1 Status|de|P0013 DO5...DO1 Status|es|P0013 Estado DO5...DO1";
	CLASS CONTAINED;
	TYPE BIT_ENUMERATED(2)
	{
		{ 0x01, "DO1", [RL_HELP] },
		{ 0x02, "DO2", [RL_HELP] },
		{ 0x04, "DO3", [RL_HELP] },
		{ 0x08, "DO4", [DO_HELP] },
		{ 0x10, "DO5", [DO_HELP] }
	}
	HANDLING READ;
}

COMMAND READ_P0013
{
	SLOT 0;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0013 }
	}
}

VARIABLE P0680
{
	LABEL "P0680 Logical Status|de|P0680 Logischer Status|es|P0680 Estado Lgico";
	CLASS CONTAINED;
	TYPE BIT_ENUMERATED(2)
	{
		{ 0x0001, [RESERVED] },
		{ 0x0002, [RESERVED] },
		{ 0x0004, [RESERVED] },
		{ 0x0008, [RESERVED] },
		{ 0x0010, [RESERVED] },
		{ 0x0020, [RESERVED] },
		{ 0x0040, [STS_BIT06] },
		{ 0x0080, [STS_BIT07] },
		{ 0x0100, [STS_BIT08] },
		{ 0x0200, [STS_BIT09] },
		{ 0x0400, [STS_BIT10] },
		{ 0x0800, [STS_BIT11] },
		{ 0x1000, [STS_BIT12] },
		{ 0x2000, [STS_BIT13] },
		{ 0x4000, [STS_BIT14] },
		{ 0x8000, [STS_BIT15] }
	}
	HANDLING READ;
}

COMMAND READ_P0680
{
	SLOT 2;
	INDEX 169;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0680 }
	}
}

VARIABLE P0686
{
	LABEL "P0686 Anybus-CC Control|de|P0686 Anybus-CC Kontrolle|es|P0686 Control Anybus-CC";
	CLASS CONTAINED;
	TYPE BIT_ENUMERATED(2)
	{
		{ 0x0001, [CTRL_BIT00] },
		{ 0x0002, [CTRL_BIT01] },
		{ 0x0004, [CTRL_BIT02] },
		{ 0x0008, [CTRL_BIT03] },
		{ 0x0010, [CTRL_BIT04] },
		{ 0x0020, [RESERVED] },
		{ 0x0040, [RESERVED] },
		{ 0x0080, [CTRL_BIT07] },
		{ 0x0100, [RESERVED] },
		{ 0x0200, [RESERVED] },
		{ 0x0400, [RESERVED] },
		{ 0x0800, [RESERVED] },
		{ 0x1000, [RESERVED] },
		{ 0x2000, [RESERVED] },
		{ 0x4000, [RESERVED] },
		{ 0x8000, [RESERVED] }
	}
}

COMMAND READ_P0686
{
	SLOT 2;
	INDEX 175;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0686 }
	}
}

WRITE_P0686 LIKE READ_P0686
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0686 }
		REPLY { }
	}
}

P0695 LIKE P0013
{
	REDEFINE LABEL "P0695 DOx Value|de|P0695 DOx Wert|es|P0695 Valor para DOx";
	REDEFINE HANDLING READ & WRITE;
}

COMMAND READ_P0695
{
	SLOT 2;
	INDEX 184;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0695 }
	}
}

WRITE_P0695 LIKE READ_P0695
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0695 }
		REPLY { }
	}
}

VARIABLE P0001
{
	LABEL "P0001 Speed Reference|de|P0001 Drehzahlsollwert|es|P0001 Referencia Velocidad";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0001
{
	SLOT 0;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0001 }
	}
}

VARIABLE P0002
{
	LABEL "P0002 Motor Speed     |de|P0002 Motordrehzahl|es|P0002 Velocidad Motor ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0002
{
	SLOT 0;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0002 }
	}
}

VARIABLE P0003
{
	LABEL "P0003 Motor Current   |de|P0003 Motorstrom|es|P0003 Corriente Motor ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
	HANDLING READ;
}

COMMAND READ_P0003
{
	SLOT 0;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0003 }
	}
}

VARIABLE P0004
{
	LABEL "P0004 DC Link Voltage (Ud)|de|P0004 Zwischenkreisspannung|es|P0004 Tensin Barram. CC";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 2000;
	}
	CONSTANT_UNIT "V";
	HANDLING READ;
}

COMMAND READ_P0004
{
	SLOT 0;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0004 }
	}
}

VARIABLE P0005
{
	LABEL "P0005 Motor Frequency |de|P0005 Motorfrequenz|es|P0005 Frecuencia Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "Hz";
	HANDLING READ;
}

COMMAND READ_P0005
{
	SLOT 0;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0005 }
	}
}

VARIABLE P0006
{
	LABEL "P0006 VFD Status      |de|P0006 Umrichterstatus|es|P0006 Estado Convertidor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Ready|de|Ready (Bereit)|es|Ready (Pronto)" },
		{ 1, "Run  |de|Run (Betrieb)|es|Run(Ejecucin)" },
		{ 2, "Undervoltage|de|Unterspannung|es|Subtensin" },
		{ 3, "Fault|de|Fehler|es|Falla" },
		{ 4, "Self-Tuning|de|Selbstabgleich|es|Autoajuste" },
		{ 5, "Configuration|de|Konfiguration|es|Configuracin" },
		{ 6, "DC-Braking|de|G.Strom-Bremse|es|Frenado CC" },
		{ 7, "STO|de|STO|es|STO" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0006
{
	SLOT 0;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0006 }
	}
}

VARIABLE P0007
{
	LABEL "P0007 Motor Voltage   |de|P0007 Motorspannung|es|P0007 Tensin Salida  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 2000;
	}
	CONSTANT_UNIT "V";
	HANDLING READ;
}

COMMAND READ_P0007
{
	SLOT 0;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0007 }
	}
}

VARIABLE P0009
{
	LABEL "P0009 Motor Torque    |de|P0009 Motordrehmoment|es|P0009 Torque en el Motor ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0009
{
	SLOT 0;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0009 }
	}
}

VARIABLE P0010
{
	LABEL "P0010 Output Power    |de|P0010 Ausgangsleistung|es|P0010 Potencia Salida ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "kW";
	HANDLING READ;
}

COMMAND READ_P0010
{
	SLOT 0;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0010 }
	}
}

VARIABLE P0014
{
	LABEL "P0014 AO1 Value       |de|P0014 AO1 Wert|es|P0014 Valor de AO1    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0014
{
	SLOT 0;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0014 }
	}
}

VARIABLE P0015
{
	LABEL "P0015 AO2 Value       |de|P0015 AO2 Wert|es|P0015 Valor de AO2    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0015
{
	SLOT 0;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0015 }
	}
}

VARIABLE P0016
{
	LABEL "P0016 AO3 Value       |de|P0016 AO3 Wert|es|P0016 Valor de AO3    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0016
{
	SLOT 0;
	INDEX 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0016 }
	}
}

VARIABLE P0017
{
	LABEL "P0017 AO4 Value       |de|P0017 AO4 Wert|es|P0017 Valor de AO4    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0017
{
	SLOT 0;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0017 }
	}
}

VARIABLE P0018
{
	LABEL "P0018 AI1 Value       |de|P0018 AI1 Wert|es|P0018 Valor de AI1    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0018
{
	SLOT 0;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0018 }
	}
}

VARIABLE P0019
{
	LABEL "P0019 AI2 Value       |de|P0019 AI2 Wert|es|P0019 Valor de AI2    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0019
{
	SLOT 0;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0019 }
	}
}

VARIABLE P0020
{
	LABEL "P0020 AI3 Value       |de|P0020 AI3 Wert|es|P0020 Valor de AI3    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0020
{
	SLOT 0;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0020 }
	}
}

VARIABLE P0021
{
	LABEL "P0021 AI4 Value       |de|P0021 AI4 Wert|es|P0021 Valor de AI4    ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0021
{
	SLOT 0;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0021 }
	}
}

VARIABLE P0023
{
	LABEL "P0023 Software Version|de|P0023 Softwareversion|es|P0023 Versin Software ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	HANDLING READ;
}

COMMAND READ_P0023
{
	SLOT 0;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0023 }
	}
}

VARIABLE P0027
{
	LABEL "P0027 Accessories Config. 1|de|P0027 Zubehrkonfig. 1|es|P0027 Config. Accesorios 1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0027
{
	SLOT 0;
	INDEX 26;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0027 }
	}
}

VARIABLE P0028
{
	LABEL "P0028 Accessories Config. 2|de|P0028 Zubehrkonfig. 2|es|P0028 Config. Accesorios 2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0028
{
	SLOT 0;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0028 }
	}
}

VARIABLE P0029
{
	LABEL "P0029 Power Hardware Config|de|P0029 Leistungs-HW Konfig.|es|P0029 Config. HW Potencia";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0029
{
	SLOT 0;
	INDEX 28;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0029 }
	}
}

VARIABLE P0030
{
	LABEL "P0030 IGBTs Temperature U|de|P0030 Temperatur IGBTs U|es|P0030 Temperatura IGBTs U";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0030
{
	SLOT 0;
	INDEX 29;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0030 }
	}
}

VARIABLE P0031
{
	LABEL "P0031 IGBTs Temperature V|de|P0031 Temperatur IGBTs V|es|P0031 Temperatura IGBTs V";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0031
{
	SLOT 0;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0031 }
	}
}

VARIABLE P0032
{
	LABEL "P0032 IGBTs Temperature W|de|P0032 Temperatur IGBTs W|es|P0032 Temperatura IGBTs W";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0032
{
	SLOT 0;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0032 }
	}
}

VARIABLE P0033
{
	LABEL "P0033 Rectifier Temperature|de|P0033 Gleichrichtertemp.|es|P0033 Temper. Rectificador";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0033
{
	SLOT 0;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0033 }
	}
}

VARIABLE P0034
{
	LABEL "P0034 Internal Air Temp.|de|P0034 Interne Lufttemp.|es|P0034 Temper. Aire Interno";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0034
{
	SLOT 0;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0034 }
	}
}

VARIABLE P0036
{
	LABEL "P0036 Fan Heatsink Speed|de|P0036 Lftergeschwindigkeit|es|P0036 Velocidad Ventilador";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 15000;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0036
{
	SLOT 0;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0036 }
	}
}

VARIABLE P0037
{
	LABEL "P0037 Motor Overload Status|de|P0037 Motorberlaststatus|es|P0037 Sobrecarga del Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0037
{
	SLOT 0;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0037 }
	}
}

VARIABLE P0038
{
	LABEL "P0038 Encoder Speed|de|P0038 Drehgeber Geschw.|es|P0038 Velocidad del Encoder";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0038
{
	SLOT 0;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0038 }
	}
}

VARIABLE P0040
{
	LABEL "P0040 PID Process Variable|de|P0040 Prozessvariable|es|P0040 Variable Proceso PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0040
{
	SLOT 0;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0040 }
	}
}

VARIABLE P0041
{
	LABEL "P0041 PID Setpoint Value|de|P0041 PID Sollwert|es|P0041 Valor Setpoint PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0041
{
	SLOT 0;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0041 }
	}
}

VARIABLE P0042
{
	LABEL "P0042 Time Powered    |de|P0042 Einschaltzeit|es|P0042 Horas Energizado";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	CONSTANT_UNIT "h";
	HANDLING READ;
}

COMMAND READ_P0042
{
	SLOT 0;
	INDEX 41;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0042 }
	}
}

VARIABLE P0043
{
	LABEL "P0043 Time Enabled    |de|P0043 Betriebszeit|es|P0043 Horas Habilitado";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "h";
	HANDLING READ;
}

COMMAND READ_P0043
{
	SLOT 0;
	INDEX 42;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0043 }
	}
}

VARIABLE P0044
{
	LABEL "P0044 kWh Output Energy|de|P0044 kWh-Zhler|es|P0044 Contador kWh";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	CONSTANT_UNIT "kWh";
	HANDLING READ;
}

COMMAND READ_P0044
{
	SLOT 0;
	INDEX 43;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0044 }
	}
}

VARIABLE P0045
{
	LABEL "P0045 Fan Enabled Time|de|P0045 Laufzeit Lfter|es|P0045 Horas Ventil. Ligado";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	CONSTANT_UNIT "h";
	HANDLING READ;
}

COMMAND READ_P0045
{
	SLOT 0;
	INDEX 44;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0045 }
	}
}

VARIABLE P0048
{
	LABEL "P0048 Present Alarm      |de|P0048 Aktueller Alarm|es|P0048 Alarma Actual";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0048
{
	SLOT 0;
	INDEX 47;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0048 }
	}
}

VARIABLE P0049
{
	LABEL "P0049 Present Fault|de|P0049 Aktueller Fehler|es|P0049 Falla Actual";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0049
{
	SLOT 0;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0049 }
	}
}

VARIABLE P0050
{
	LABEL "P0050 Last Fault|de|P0050 Letzter Fehler|es|P0050 ltima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0050
{
	SLOT 0;
	INDEX 49;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0050 }
	}
}

VARIABLE P0051
{
	LABEL "P0051 Last Fault Day/Month|de|P0051 Tag/Monat letzter F. |es|P0051 Da/Mes ltima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0051 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0051
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0051 = (P0051&0x00FF) + (P0051>>8)*100; }
}

COMMAND READ_P0051
{
	SLOT 0;
	INDEX 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0051 }
	}
}

VARIABLE P0052
{
	LABEL "P0052 Last Fault Year|de|P0052 Jahr letzter Fehler |es|P0052 Ao ltima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0052
{
	SLOT 0;
	INDEX 51;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0052 }
	}
}

VARIABLE P0053
{
	LABEL "P0053 Last Fault Time|de|P0053 Zeit letzter Fehler|es|P0053 Hora ltima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0053 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0053
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0053 = (P0053&0x00FF) + (P0053>>8)*100; }
}

COMMAND READ_P0053
{
	SLOT 0;
	INDEX 52;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0053 }
	}
}

VARIABLE P0054
{
	LABEL "P0054 Second Fault|de|P0054 Zweiter Fehler|es|P0054 Segunda Falla   ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0054
{
	SLOT 0;
	INDEX 53;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0054 }
	}
}

VARIABLE P0055
{
	LABEL "P0055 Second Flt. Day/Month|de|P0055 Tag/Monat 2. Fehler |es|P0055 Da/Mes Segunda Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0055 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0055
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0055 = (P0055&0x00FF) + (P0055>>8)*100; }
}

COMMAND READ_P0055
{
	SLOT 0;
	INDEX 54;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0055 }
	}
}

VARIABLE P0056
{
	LABEL "P0056 Second Fault Year|de|P0056 Jahr 2. Fehler|es|P0056 Ao Segunda Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0056
{
	SLOT 0;
	INDEX 55;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0056 }
	}
}

VARIABLE P0057
{
	LABEL "P0057 Second Fault Time|de|P0057 Zeit 2. Fehler|es|P0057 Hora Segunda Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0057 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0057
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0057 = (P0057&0x00FF) + (P0057>>8)*100; }
}

COMMAND READ_P0057
{
	SLOT 0;
	INDEX 56;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0057 }
	}
}

VARIABLE P0058
{
	LABEL "P0058 Third Fault|de|P0058 Dritter Fehler|es|P0058 Tercera Falla   ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0058
{
	SLOT 0;
	INDEX 57;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0058 }
	}
}

VARIABLE P0059
{
	LABEL "P0059 Third Fault Day/Month|de|P0059 Tag/Monat 3. Fehler |es|P0059 Da/Mes Tercera Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0059 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0059
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0059 = (P0059&0x00FF) + (P0059>>8)*100; }
}

COMMAND READ_P0059
{
	SLOT 0;
	INDEX 58;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0059 }
	}
}

VARIABLE P0060
{
	LABEL "P0060 Third Fault Year|de|P0060 Jahr 3. Fehler|es|P0060 Ao Tercera Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0060
{
	SLOT 0;
	INDEX 59;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0060 }
	}
}

VARIABLE P0061
{
	LABEL "P0061 Third Fault Time|de|P0061 Zeit 3. Fehler|es|P0061 Hora Tercera Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0061 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0061
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0061 = (P0061&0x00FF) + (P0061>>8)*100; }
}

COMMAND READ_P0061
{
	SLOT 0;
	INDEX 60;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0061 }
	}
}

VARIABLE P0062
{
	LABEL "P0062 Fourth Fault|de|P0062 Vierter Fehler|es|P0062 Cuarta Falla    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0062
{
	SLOT 0;
	INDEX 61;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0062 }
	}
}

VARIABLE P0063
{
	LABEL "P0063 Fourth Flt. Day/Month|de|P0063 Tag/Monat 4. Fehler |es|P0063 Da/Mes Cuarta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0063 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0063
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0063 = (P0063&0x00FF) + (P0063>>8)*100; }
}

COMMAND READ_P0063
{
	SLOT 0;
	INDEX 62;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0063 }
	}
}

VARIABLE P0064
{
	LABEL "P0064 Fourth Fault Year|de|P0064 Jahr 4. Fehler|es|P0064 Ao Cuarta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0064
{
	SLOT 0;
	INDEX 63;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0064 }
	}
}

VARIABLE P0065
{
	LABEL "P0065 Fourth Fault Time|de|P0065 Zeit 4. Fehler|es|P0065 Hora Cuarta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0065 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0065
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0065 = (P0065&0x00FF) + (P0065>>8)*100; }
}

COMMAND READ_P0065
{
	SLOT 0;
	INDEX 64;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0065 }
	}
}

VARIABLE P0066
{
	LABEL "P0066 Fifth Fault|de|P0066 Fnfter Fehler|es|P0066 Quinta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0066
{
	SLOT 0;
	INDEX 65;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0066 }
	}
}

VARIABLE P0067
{
	LABEL "P0067 Fifth Fault Day/Month|de|P0067 Tag/Monat 5. Fehler |es|P0067 Da/Mes Quinta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0067 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0067
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0067 = (P0067&0x00FF) + (P0067>>8)*100; }
}

COMMAND READ_P0067
{
	SLOT 0;
	INDEX 66;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0067 }
	}
}

VARIABLE P0068
{
	LABEL "P0068 Fifth Fault Year|de|P0068 Jahr 5. Fehler|es|P0068 Ao Quinta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0068
{
	SLOT 0;
	INDEX 67;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0068 }
	}
}

VARIABLE P0069
{
	LABEL "P0069 Fifth Fault Time|de|P0069 Zeit 5. Fehler|es|P0069 Hora Quinta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0069 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0069
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0069 = (P0069&0x00FF) + (P0069>>8)*100; }
}

COMMAND READ_P0069
{
	SLOT 0;
	INDEX 68;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0069 }
	}
}

VARIABLE P0070
{
	LABEL "P0070 Sixth Fault|de|P0070 Sechster Fehler|es|P0070 Sexta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0070
{
	SLOT 0;
	INDEX 69;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0070 }
	}
}

VARIABLE P0071
{
	LABEL "P0071 Sixth Fault Day/Month|de|P0071 Tag/Monat 6. Fehler |es|P0071 Da/Mes Sexta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0071 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0071
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0071 = (P0071&0x00FF) + (P0071>>8)*100; }
}

COMMAND READ_P0071
{
	SLOT 0;
	INDEX 70;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0071 }
	}
}

VARIABLE P0072
{
	LABEL "P0072 Sixth Fault Year|de|P0072 Jahr 6. Fehler|es|P0072 Ao Sexta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0072
{
	SLOT 0;
	INDEX 71;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0072 }
	}
}

VARIABLE P0073
{
	LABEL "P0073 Sixth Fault Time|de|P0073 Zeit 6. Fehler|es|P0073 Hora Sexta Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0073 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0073
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0073 = (P0073&0x00FF) + (P0073>>8)*100; }
}

COMMAND READ_P0073
{
	SLOT 0;
	INDEX 72;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0073 }
	}
}

VARIABLE P0074
{
	LABEL "P0074 Seventh Fault|de|P0074 Siebter Fehler|es|P0074 Sptima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0074
{
	SLOT 0;
	INDEX 73;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0074 }
	}
}

VARIABLE P0075
{
	LABEL "P0075 Seventh Flt.Day/Month|de|P0075 Tag/Monat 7. Fehler |es|P0075 Da/Mes Sptima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0075 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0075
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0075 = (P0075&0x00FF) + (P0075>>8)*100; }
}

COMMAND READ_P0075
{
	SLOT 0;
	INDEX 74;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0075 }
	}
}

VARIABLE P0076
{
	LABEL "P0076 Seventh Fault Year|de|P0076 Jahr 7. Fehler|es|P0076 Ao Sptima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0076
{
	SLOT 0;
	INDEX 75;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0076 }
	}
}

VARIABLE P0077
{
	LABEL "P0077 Seventh Fault Time|de|P0077 Zeit 7. Fehler|es|P0077 Hora Sptima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0077 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0077
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0077 = (P0077&0x00FF) + (P0077>>8)*100; }
}

COMMAND READ_P0077
{
	SLOT 0;
	INDEX 76;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0077 }
	}
}

VARIABLE P0078
{
	LABEL "P0078 Eighth Fault|de|P0078 Achter Fehler|es|P0078 Octava Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0078
{
	SLOT 0;
	INDEX 77;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0078 }
	}
}

VARIABLE P0079
{
	LABEL "P0079 Eighth Flt. Day/Month|de|P0079 Tag/Monat 8. Fehler |es|P0079 Da/Mes Octava Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0079 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0079
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0079 = (P0079&0x00FF) + (P0079>>8)*100; }
}

COMMAND READ_P0079
{
	SLOT 0;
	INDEX 78;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0079 }
	}
}

VARIABLE P0080
{
	LABEL "P0080 Eighth Fault Year|de|P0080 Jahr 8. Fehler|es|P0080 Ao Octava Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0080
{
	SLOT 0;
	INDEX 79;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0080 }
	}
}

VARIABLE P0081
{
	LABEL "P0081 Eighth Fault Time|de|P0081 Zeit 8. Fehler|es|P0081 Hora Octava Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0081 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0081
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0081 = (P0081&0x00FF) + (P0081>>8)*100; }
}

COMMAND READ_P0081
{
	SLOT 0;
	INDEX 80;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0081 }
	}
}

VARIABLE P0082
{
	LABEL "P0082 Ninth Fault|de|P0082 Neunter Fehler|es|P0082 Novena Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0082
{
	SLOT 0;
	INDEX 81;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0082 }
	}
}

VARIABLE P0083
{
	LABEL "P0083 Ninth Fault Day/Month|de|P0083 Tag/Monat 9. Fehler |es|P0083 Da/Mes Novena Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0083 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0083
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0083 = (P0083&0x00FF) + (P0083>>8)*100; }
}

COMMAND READ_P0083
{
	SLOT 0;
	INDEX 82;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0083 }
	}
}

VARIABLE P0084
{
	LABEL "P0084 Ninth Fault Year|de|P0084 Jahr 9. Fehler|es|P0084 Ao Novena Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0084
{
	SLOT 0;
	INDEX 83;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0084 }
	}
}

VARIABLE P0085
{
	LABEL "P0085 Ninth Fault Time|de|P0085 Zeit 9. Fehler|es|P0085 Hora Novena Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0085 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0085
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0085 = (P0085&0x00FF) + (P0085>>8)*100; }
}

COMMAND READ_P0085
{
	SLOT 0;
	INDEX 84;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0085 }
	}
}

VARIABLE P0086
{
	LABEL "P0086 Tenth Fault|de|P0086 Zehnter Fehler|es|P0086 Dcima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	HANDLING READ;
}

COMMAND READ_P0086
{
	SLOT 0;
	INDEX 85;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0086 }
	}
}

VARIABLE P0087
{
	LABEL "P0087 Tenth Fault Day/Month|de|P0087 Tag/Monat 10. Fehler |es|P0087 Da/Mes Dcima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0087 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0087
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0087 = (P0087&0x00FF) + (P0087>>8)*100; }
}

COMMAND READ_P0087
{
	SLOT 0;
	INDEX 86;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0087 }
	}
}

VARIABLE P0088
{
	LABEL "P0088 Tenth Fault Year|de|P0088 Jahr 10. Fehler|es|P0088 Ao Dcima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0088
{
	SLOT 0;
	INDEX 87;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0088 }
	}
}

VARIABLE P0089
{
	LABEL "P0089 Tenth Fault Time|de|P0089 Zeit 10. Fehler|es|P0089 Hora Dcima Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0089 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0089
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0089 = (P0089&0x00FF) + (P0089>>8)*100; }
}

COMMAND READ_P0089
{
	SLOT 0;
	INDEX 88;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0089 }
	}
}

VARIABLE P0090
{
	LABEL "P0090 Current At Last Fault|de|P0090 Strom beim letzen F.|es|P0090 Corriente lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
	HANDLING READ;
}

COMMAND READ_P0090
{
	SLOT 0;
	INDEX 89;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0090 }
	}
}

VARIABLE P0091
{
	LABEL "P0091 DC Link At Last Fault|de|P0091 Zwischenkeispg. l. F.|es|P0091 Barram. CC lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 2000;
	}
	CONSTANT_UNIT "V";
	HANDLING READ;
}

COMMAND READ_P0091
{
	SLOT 0;
	INDEX 90;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0091 }
	}
}

VARIABLE P0092
{
	LABEL "P0092 Speed At Last Fault|de|P0092 Geschwindigkeit l. F.|es|P0092 Velocidad lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0092
{
	SLOT 0;
	INDEX 91;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0092 }
	}
}

VARIABLE P0093
{
	LABEL "P0093 Reference Last Fault|de|P0093 Sollwert letzter F.|es|P0093 Referencia lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
	HANDLING READ;
}

COMMAND READ_P0093
{
	SLOT 0;
	INDEX 92;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0093 }
	}
}

VARIABLE P0094
{
	LABEL "P0094 Frequency Last Fault|de|P0094 Frequenz letzter F.|es|P0094 Frecuencia lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "Hz";
	HANDLING READ;
}

COMMAND READ_P0094
{
	SLOT 0;
	INDEX 93;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0094 }
	}
}

VARIABLE P0095
{
	LABEL "P0095 Motor Volt.Last Fault|de|P0095 Motorspannung l. F.|es|P0095 Tensin Mot.lt.Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 2000;
	}
	CONSTANT_UNIT "V";
	HANDLING READ;
}

COMMAND READ_P0095
{
	SLOT 0;
	INDEX 94;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0095 }
	}
}

VARIABLE P0096
{
	LABEL "P0096 DIx Status Last Fault|de|P0096 DIx Status letzter F.|es|P0096 Estado DIx lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 255;
	}
	HANDLING READ;
}

COMMAND READ_P0096
{
	SLOT 0;
	INDEX 95;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0096 }
	}
}

VARIABLE P0097
{
	LABEL "P0097 DOx Status Last Fault|de|P0097 DOx Status letzter F.|es|P0097 Estado DOx lt. Falla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 31;
	}
	HANDLING READ;
}

COMMAND READ_P0097
{
	SLOT 0;
	INDEX 96;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0097 }
	}
}

VARIABLE P0100
{
	LABEL "P0100 Acceleration Time  |de|P0100 Hochlaufzeit|es|P0100 Tiempo Aceleracin  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0100
{
	SLOT 0;
	INDEX 99;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0100 }
	}
}

WRITE_P0100 LIKE READ_P0100
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0100 }
		REPLY { }
	}
}

VARIABLE P0101
{
	LABEL "P0101 Deceleration Time|de|P0101 Bremszeit|es|P0101 Tiempo Desaceleracin";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0101
{
	SLOT 0;
	INDEX 100;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0101 }
	}
}

WRITE_P0101 LIKE READ_P0101
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0101 }
		REPLY { }
	}
}

VARIABLE P0102
{
	LABEL "P0102 Acceleration Time 2|de|P0102 2. Hochlaufzeit|es|P0102 Tiempo Aceler. 2a";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0102
{
	SLOT 0;
	INDEX 101;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0102 }
	}
}

WRITE_P0102 LIKE READ_P0102
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0102 }
		REPLY { }
	}
}

VARIABLE P0103
{
	LABEL "P0103 Deceleration Time 2|de|P0103 2. Bremszeit|es|P0103 Tiempo Desacel. 2a";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0103
{
	SLOT 0;
	INDEX 102;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0103 }
	}
}

WRITE_P0103 LIKE READ_P0103
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0103 }
		REPLY { }
	}
}

VARIABLE P0104
{
	LABEL "P0104 S Ramp          |de|P0104 S-Rampe|es|P0104 Rampa S         ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "50%|de|50%|es|50%" },
		{ 2, "100%|de|100%|es|100%" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0104
{
	SLOT 0;
	INDEX 103;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0104 }
	}
}

WRITE_P0104 LIKE READ_P0104
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0104 }
		REPLY { }
	}
}

VARIABLE P0120
{
	LABEL "P0120 Speed Ref. Backup|de|P0120 Sollwertbackup|es|P0120 Backup Referencia";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0120
{
	SLOT 0;
	INDEX 119;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0120 }
	}
}

WRITE_P0120 LIKE READ_P0120
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0120 }
		REPLY { }
	}
}

VARIABLE P0121
{
	LABEL "P0121 Keypad Reference|de|P0121 Tastatursollwert|es|P0121 Referencia Tecla";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 90;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0121
{
	SLOT 0;
	INDEX 120;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0121 }
	}
}

WRITE_P0121 LIKE READ_P0121
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0121 }
		REPLY { }
	}
}

VARIABLE P0122
{
	LABEL "P0122 JOG/JOG+ Reference   |de|P0122 JOG/JOG+ Sollwert|es|P0122 Referencia JOG/JOG+  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 150;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0122
{
	SLOT 0;
	INDEX 121;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0122 }
	}
}

WRITE_P0122 LIKE READ_P0122
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0122 }
		REPLY { }
	}
}

VARIABLE P0123
{
	LABEL "P0123 JOG- Reference  |de|P0123 JOG- Sollwert|es|P0123 Referencia JOG- ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 150;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0123
{
	SLOT 0;
	INDEX 122;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0123 }
	}
}

WRITE_P0123 LIKE READ_P0123
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0123 }
		REPLY { }
	}
}

VARIABLE P0124
{
	LABEL "P0124 Multispeed Ref. 1|de|P0124 Multispeedsollwert 1|es|P0124 Ref. 1 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 90;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0124
{
	SLOT 0;
	INDEX 123;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0124 }
	}
}

WRITE_P0124 LIKE READ_P0124
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0124 }
		REPLY { }
	}
}

VARIABLE P0125
{
	LABEL "P0125 Multispeed Ref. 2|de|P0125 Multispeedsollwert 2|es|P0125 Ref. 2 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 300;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0125
{
	SLOT 0;
	INDEX 124;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0125 }
	}
}

WRITE_P0125 LIKE READ_P0125
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0125 }
		REPLY { }
	}
}

VARIABLE P0126
{
	LABEL "P0126 Multispeed Ref. 3|de|P0126 Multispeedsollwert 3|es|P0126 Ref. 3 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 600;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0126
{
	SLOT 0;
	INDEX 125;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0126 }
	}
}

WRITE_P0126 LIKE READ_P0126
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0126 }
		REPLY { }
	}
}

VARIABLE P0127
{
	LABEL "P0127 Multispeed Ref. 4|de|P0127 Multispeedsollwert 4|es|P0127 Ref. 4 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 900;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0127
{
	SLOT 0;
	INDEX 126;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0127 }
	}
}

WRITE_P0127 LIKE READ_P0127
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0127 }
		REPLY { }
	}
}

VARIABLE P0128
{
	LABEL "P0128 Multispeed Ref. 5|de|P0128 Multispeedsollwert 5|es|P0128 Ref. 5 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1200;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0128
{
	SLOT 0;
	INDEX 127;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0128 }
	}
}

WRITE_P0128 LIKE READ_P0128
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0128 }
		REPLY { }
	}
}

VARIABLE P0129
{
	LABEL "P0129 Multispeed Ref. 6|de|P0129 Multispeedsollwert 6|es|P0129 Ref. 6 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1500;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0129
{
	SLOT 0;
	INDEX 128;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0129 }
	}
}

WRITE_P0129 LIKE READ_P0129
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0129 }
		REPLY { }
	}
}

VARIABLE P0130
{
	LABEL "P0130 Multispeed Ref. 7|de|P0130 Multispeedsollwert 7|es|P0130 Ref. 7 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1800;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0130
{
	SLOT 0;
	INDEX 129;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0130 }
	}
}

WRITE_P0130 LIKE READ_P0130
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0130 }
		REPLY { }
	}
}

VARIABLE P0131
{
	LABEL "P0131 Multispeed Ref. 8|de|P0131 Multispeedsollwert 8|es|P0131 Ref. 8 Multispeed";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1650;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0131
{
	SLOT 0;
	INDEX 130;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0131 }
	}
}

WRITE_P0131 LIKE READ_P0131
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0131 }
		REPLY { }
	}
}

VARIABLE P0132
{
	LABEL "P0132 Max. Overspeed Level|de|P0132 berdrehzahlniveau|es|P0132 Nivel Mx.Sobreveloc.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 10;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0132
{
	SLOT 0;
	INDEX 131;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0132 }
	}
}

WRITE_P0132 LIKE READ_P0132
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0132 }
		REPLY { }
	}
}

VARIABLE P0133
{
	LABEL "P0133 Minimum Speed   |de|P0133 Minimaldrehzahl|es|P0133 Velocidad Mnima";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 90;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0133
{
	SLOT 0;
	INDEX 132;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0133 }
	}
}

WRITE_P0133 LIKE READ_P0133
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0133 }
		REPLY { }
	}
}

VARIABLE P0134
{
	LABEL "P0134 Maximum Speed   |de|P0134 Maximaldrehzahl|es|P0134 Velocidad Mxima";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1800;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0134
{
	SLOT 0;
	INDEX 133;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0134 }
	}
}

WRITE_P0134 LIKE READ_P0134
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0134 }
		REPLY { }
	}
}

VARIABLE P0135
{
	LABEL "P0135 Max. Output Current|de|P0135 Maximalstrom|es|P0135 Corriente Mx. Salida";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0135
{
	SLOT 0;
	INDEX 134;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0135 }
	}
}

WRITE_P0135 LIKE READ_P0135
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0135 }
		REPLY { }
	}
}

VARIABLE P0136
{
	LABEL "P0136 Manual Torque Boost|de|P0136 Kompensation IxR|es|P0136 Compensacin IxR";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1;
		MIN_VALUE 0;
		MAX_VALUE 9;
	}
}

COMMAND READ_P0136
{
	SLOT 0;
	INDEX 135;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0136 }
	}
}

WRITE_P0136 LIKE READ_P0136
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0136 }
		REPLY { }
	}
}

VARIABLE P0137
{
	LABEL "P0137 Autom. Torque Boost|de|P0137 Autokompens. IxR|es|P0137 Ganancia IxR Autom.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0137
{
	SLOT 0;
	INDEX 136;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0137 }
	}
}

WRITE_P0137 LIKE READ_P0137
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0137 }
		REPLY { }
	}
}

VARIABLE P0138
{
	LABEL "P0138 Slip Compensation|de|P0138 Nennschlupf|es|P0138 Deslizamiento Nominal";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0138
{
	SLOT 0;
	INDEX 137;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0138 }
	}
}

WRITE_P0138 LIKE READ_P0138
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0138 }
		REPLY { }
	}
}

VARIABLE P0139
{
	LABEL "P0139 Output Current Filter|de|P0139 Filterstrom|es|P0139 Filtro Corr. Salida";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0139
{
	SLOT 0;
	INDEX 138;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0139 }
	}
}

WRITE_P0139 LIKE READ_P0139
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0139 }
		REPLY { }
	}
}

VARIABLE P0140
{
	LABEL "P0140 Dwell Time At Start  |de|P0140 Dwell Zeit|es|P0140 Tiempo Acomodacin";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0140
{
	SLOT 0;
	INDEX 139;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0140 }
	}
}

WRITE_P0140 LIKE READ_P0140
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0140 }
		REPLY { }
	}
}

VARIABLE P0141
{
	LABEL "P0141 Dwell Speed At Start|de|P0141 Dwell Drehzahl|es|P0141 Velocidad Acomodacin";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 90;
		MIN_VALUE 0;
		MAX_VALUE 300;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0141
{
	SLOT 0;
	INDEX 140;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0141 }
	}
}

WRITE_P0141 LIKE READ_P0141
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0141 }
		REPLY { }
	}
}

VARIABLE P0142
{
	LABEL "P0142 Max. Output Voltage|de|P0142 Maximale Motorspg.|es|P0142 Tensin Mxima  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0142
{
	SLOT 0;
	INDEX 141;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0142 }
	}
}

WRITE_P0142 LIKE READ_P0142
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0142 }
		REPLY { }
	}
}

VARIABLE P0143
{
	LABEL "P0143 Interm.Output Voltage|de|P0143 Durchschn. Motorspg.|es|P0143 Tensin Intermediria";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0143
{
	SLOT 0;
	INDEX 142;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0143 }
	}
}

WRITE_P0143 LIKE READ_P0143
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0143 }
		REPLY { }
	}
}

VARIABLE P0144
{
	LABEL "P0144 3Hz Output Voltage|de|P0144 Spannung bei 3Hz|es|P0144 Tensin en 3Hz  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0144
{
	SLOT 0;
	INDEX 143;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0144 }
	}
}

WRITE_P0144 LIKE READ_P0144
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0144 }
		REPLY { }
	}
}

VARIABLE P0145
{
	LABEL "P0145 Field Weakening Speed|de|P0145 Feldschwchdrehzahl|es|P0145 Vel. Inicio Deb.Campo";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1800;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0145
{
	SLOT 0;
	INDEX 144;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0145 }
	}
}

WRITE_P0145 LIKE READ_P0145
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0145 }
		REPLY { }
	}
}

VARIABLE P0146
{
	LABEL "P0146 Intermediate Speed |de|P0146 Durchschn. Drehzahl|es|P0146 Vel. Intermediria  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 900;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0146
{
	SLOT 0;
	INDEX 145;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0146 }
	}
}

WRITE_P0146 LIKE READ_P0146
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0146 }
		REPLY { }
	}
}

VARIABLE P0150
{
	LABEL "P0150 DC Regul. Type V/f|de|P0150 DC Kontrollart  V/f|es|P0150 Tipo Regul. Ud V/f";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Ramp Hold|de|Halterampe|es|Hold Rampa" },
		{ 1, "Ramp Accel.|de|Hochlauframpe|es|Acelera Rampa" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0150
{
	SLOT 0;
	INDEX 149;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0150 }
	}
}

WRITE_P0150 LIKE READ_P0150
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0150 }
		REPLY { }
	}
}

VARIABLE P0151
{
	LABEL "P0151 DC Regul. Level V/f|de|P0151 Zwischenkr.Pegel V/f|es|P0151 Nivel Reg. DC V/f   ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0151
{
	SLOT 0;
	INDEX 150;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0151 }
	}
}

WRITE_P0151 LIKE READ_P0151
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0151 }
		REPLY { }
	}
}

VARIABLE P0152
{
	LABEL "P0152 DC Link Regul. P Gain|de|P0152 Zwischenkr.Vrst.|es|P0152 Ganancia Prop.Reg. Ud";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0152
{
	SLOT 0;
	INDEX 151;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0152 }
	}
}

WRITE_P0152 LIKE READ_P0152
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0152 }
		REPLY { }
	}
}

VARIABLE P0153
{
	LABEL "P0153 Dyn. Braking Level |de|P0153 Dyn. Bremspegel|es|P0153 Nivel Frenado Reost.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0153
{
	SLOT 0;
	INDEX 152;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0153 }
	}
}

WRITE_P0153 LIKE READ_P0153
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0153 }
		REPLY { }
	}
}

VARIABLE P0154
{
	LABEL "P0154 Dyn. Braking Resistor|de|P0154 Bremswiderstand|es|P0154 Resistor Frenado ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "ohm";
}

COMMAND READ_P0154
{
	SLOT 0;
	INDEX 153;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0154 }
	}
}

WRITE_P0154 LIKE READ_P0154
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0154 }
		REPLY { }
	}
}

VARIABLE P0155
{
	LABEL "P0155 Dyn. B. Resist. Power|de|P0155 Widerstandsleistung|es|P0155 Potencia en Res.Fren.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "kW";
}

COMMAND READ_P0155
{
	SLOT 0;
	INDEX 154;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0155 }
	}
}

WRITE_P0155 LIKE READ_P0155
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0155 }
		REPLY { }
	}
}

VARIABLE P0156
{
	LABEL "P0156 Overl.Curr.100% Speed|de|P0156 berstrom 100%|es|P0156 Corriente Sobrecarga";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0156
{
	SLOT 0;
	INDEX 155;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0156 }
	}
}

WRITE_P0156 LIKE READ_P0156
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0156 }
		REPLY { }
	}
}

VARIABLE P0157
{
	LABEL "P0157 Overl.Curr. 50% Speed|de|P0157 berstrom 50%|es|P0157 Corr. Sobrecarga 50%";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0157
{
	SLOT 0;
	INDEX 156;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0157 }
	}
}

WRITE_P0157 LIKE READ_P0157
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0157 }
		REPLY { }
	}
}

VARIABLE P0158
{
	LABEL "P0158 Overl.Curr.  5% Speed|de|P0158 berstrom 5%|es|P0158 Corr. Sobrecarga 5%";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0158
{
	SLOT 0;
	INDEX 157;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0158 }
	}
}

WRITE_P0158 LIKE READ_P0158
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0158 }
		REPLY { }
	}
}

VARIABLE P0159
{
	LABEL "P0159 Motor Thermal Class|de|P0159 Thermische Schutzkl.|es|P0159 Clase Trmica Motor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Class 5|de|Klasse 5|es|Clase 5" },
		{ 1, "Class 10|de|Klasse 10|es|Clase 10" },
		{ 2, "Class 15|de|Klasse 15|es|Clase 15" },
		{ 3, "Class 20|de|Klasse 20|es|Clase 20" },
		{ 4, "Class 25|de|Klasse 25|es|Clase 25" },
		{ 5, "Class 30|de|Klasse 30|es|Clase 30" },
		{ 6, "Class 35|de|Klasse 35|es|Clase 35" },
		{ 7, "Class 40|de|Klasse 40|es|Clase 40" },
		{ 8, "Class 45|de|Klasse 45|es|Clase 45" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0159
{
	SLOT 0;
	INDEX 158;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0159 }
	}
}

WRITE_P0159 LIKE READ_P0159
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0159 }
		REPLY { }
	}
}

VARIABLE P0160
{
	LABEL "P0160 Speed Regul. Optimiz.|de|P0160 Opt. Drehz. Kontrolle|es|P0160 Optimizacin Reg.Vel.";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Normal|de|Normal|es|Normal" },
		{ 1, "Saturated|de|Gesttigt|es|Saturado" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0160
{
	SLOT 0;
	INDEX 159;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0160 }
	}
}

WRITE_P0160 LIKE READ_P0160
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0160 }
		REPLY { }
	}
}

VARIABLE P0161
{
	LABEL "P0161 Speed Prop. Gain|de|P0161 P Drehzahlverstrkung|es|P0161 Ganancia Prop. Vel.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
}

COMMAND READ_P0161
{
	SLOT 0;
	INDEX 160;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0161 }
	}
}

WRITE_P0161 LIKE READ_P0161
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0161 }
		REPLY { }
	}
}

VARIABLE P0162
{
	LABEL "P0162 Speed Integral Gain|de|P0162 I Drehzahlverstrkung|es|P0162 Ganancia Int. Vel.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0162
{
	SLOT 0;
	INDEX 161;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0162 }
	}
}

WRITE_P0162 LIKE READ_P0162
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0162 }
		REPLY { }
	}
}

VARIABLE P0163
{
	LABEL "P0163 LOC Reference Offset|de|P0163 LOC Sollwertoffset |es|P0163 Offset Referencia LOC";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -999;
		MAX_VALUE 999;
	}
}

COMMAND READ_P0163
{
	SLOT 0;
	INDEX 162;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0163 }
	}
}

WRITE_P0163 LIKE READ_P0163
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0163 }
		REPLY { }
	}
}

VARIABLE P0164
{
	LABEL "P0164 REM Reference Offset|de|P0164 REM Sollwertoffset|es|P0164 Offset Referencia REM";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -999;
		MAX_VALUE 999;
	}
}

COMMAND READ_P0164
{
	SLOT 0;
	INDEX 163;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0164 }
	}
}

WRITE_P0164 LIKE READ_P0164
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0164 }
		REPLY { }
	}
}

VARIABLE P0165
{
	LABEL "P0165 Speed Filter|de|P0165 Drehzahlfilter |es|P0165 Filtro Velocidad";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0165
{
	SLOT 0;
	INDEX 164;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0165 }
	}
}

WRITE_P0165 LIKE READ_P0165
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0165 }
		REPLY { }
	}
}

VARIABLE P0166
{
	LABEL "P0166 Speed Diff. Gain|de|P0166 D Drehzahlverstrkung|es|P0166 Ganancia Dif. Vel.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0166
{
	SLOT 0;
	INDEX 165;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0166 }
	}
}

WRITE_P0166 LIKE READ_P0166
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0166 }
		REPLY { }
	}
}

VARIABLE P0167
{
	LABEL "P0167 Current Prop. Gain|de|P0167 P Stromverstrkung|es|P0167 Ganancia Prop. Corr.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0167
{
	SLOT 0;
	INDEX 166;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0167 }
	}
}

WRITE_P0167 LIKE READ_P0167
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0167 }
		REPLY { }
	}
}

VARIABLE P0168
{
	LABEL "P0168 Current Integral Gain|de|P0168 I Stromverstrkung|es|P0168 Ganancia Int. Corr.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0168
{
	SLOT 0;
	INDEX 167;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0168 }
	}
}

WRITE_P0168 LIKE READ_P0168
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0168 }
		REPLY { }
	}
}

VARIABLE P0169
{
	LABEL "P0169 Max. CW Torque Curr.|de|P0169 Max. +Drehmomentstrom|es|P0169 Mxima Corr.Torque H";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0169
{
	SLOT 0;
	INDEX 168;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0169 }
	}
}

WRITE_P0169 LIKE READ_P0169
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0169 }
		REPLY { }
	}
}

VARIABLE P0170
{
	LABEL "P0170 Max. CCW Torque Curr.|de|P0170 Max. -Drehmomentstrom|es|P0170 Mxima Corr.Torque AH";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0170
{
	SLOT 0;
	INDEX 169;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0170 }
	}
}

WRITE_P0170 LIKE READ_P0170
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0170 }
		REPLY { }
	}
}

VARIABLE P0171
{
	LABEL "P0171 CW Torque Cur at Nmax|de|P0171 +Momentstrom bei Nmax|es|P0171 Corr.Torque H en Nmx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0171
{
	SLOT 0;
	INDEX 170;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0171 }
	}
}

WRITE_P0171 LIKE READ_P0171
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0171 }
		REPLY { }
	}
}

VARIABLE P0172
{
	LABEL "P0172 CCW TorqueCur at Nmax|de|P0172 -Momentstrom bei Nmax|es|P0172 Cor.Torque AH en Nmx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0172
{
	SLOT 0;
	INDEX 171;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0172 }
	}
}

WRITE_P0172 LIKE READ_P0172
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0172 }
		REPLY { }
	}
}

VARIABLE P0173
{
	LABEL "P0173 Max Torque Curve Type|de|P0173 Max. Drehmomentkennl.|es|P0173 Tipo Curva Torque Mx";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Ramp|de|Rampe|es|Rampa" },
		{ 1, "Step|de|Stufe|es|Escaln" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0173
{
	SLOT 0;
	INDEX 172;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0173 }
	}
}

WRITE_P0173 LIKE READ_P0173
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0173 }
		REPLY { }
	}
}

VARIABLE P0175
{
	LABEL "P0175 Flux Proport. Gain|de|P0175 P Flussverstrkung|es|P0175 Ganancia Prop. Flujo";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
}

COMMAND READ_P0175
{
	SLOT 0;
	INDEX 174;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0175 }
	}
}

WRITE_P0175 LIKE READ_P0175
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0175 }
		REPLY { }
	}
}

VARIABLE P0176
{
	LABEL "P0176 Flux Integral Gain|de|P0176 I Flussverstrkung|es|P0176 Ganancia Int. Flujo";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0176
{
	SLOT 0;
	INDEX 175;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0176 }
	}
}

WRITE_P0176 LIKE READ_P0176
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0176 }
		REPLY { }
	}
}

VARIABLE P0178
{
	LABEL "P0178 Rated Flux      |de|P0178 Nennfluss|es|P0178 Flujo Nominal   ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 100;
		MIN_VALUE 0;
		MAX_VALUE 120;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0178
{
	SLOT 0;
	INDEX 177;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0178 }
	}
}

WRITE_P0178 LIKE READ_P0178
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0178 }
		REPLY { }
	}
}

VARIABLE P0179
{
	LABEL "P0179 Maximum Flux    |de|P0179 Maximalfluss|es|P0179 Flujo Mximo    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 120;
		MIN_VALUE 0;
		MAX_VALUE 120;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0179
{
	SLOT 0;
	INDEX 178;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0179 }
	}
}

WRITE_P0179 LIKE READ_P0179
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0179 }
		REPLY { }
	}
}

VARIABLE P0180
{
	LABEL "P0180 Field Weakening Point|de|P0180 Feldschwchpunkt|es|P0180 Punto Debilit. Campo";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 95;
		MIN_VALUE 0;
		MAX_VALUE 120;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0180
{
	SLOT 0;
	INDEX 179;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0180 }
	}
}

WRITE_P0180 LIKE READ_P0180
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0180 }
		REPLY { }
	}
}

VARIABLE P0181
{
	LABEL "P0181 Magnetization Mode|de|P0181 Magnetisierungsmodus|es|P0181 Modo Magnetizar";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "General Enable|de|Freigabe|es|Habil. General" },
		{ 1, "Run/Stop  |de|Start/Stop|es|Gira/Para " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0181
{
	SLOT 0;
	INDEX 180;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0181 }
	}
}

WRITE_P0181 LIKE READ_P0181
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0181 }
		REPLY { }
	}
}

VARIABLE P0182
{
	LABEL "P0182 Speed for I/F Activ. |de|P0182 Drehzahl fr I/F|es|P0182 Veloc.p/Actuacin I/F";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 18;
		MIN_VALUE 0;
		MAX_VALUE 90;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0182
{
	SLOT 0;
	INDEX 181;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0182 }
	}
}

WRITE_P0182 LIKE READ_P0182
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0182 }
		REPLY { }
	}
}

VARIABLE P0183
{
	LABEL "P0183 Current in I/F Mode|de|P0183 Strom fr I/F|es|P0183 Corriente en modo I/F";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1;
		MIN_VALUE 0;
		MAX_VALUE 9;
	}
}

COMMAND READ_P0183
{
	SLOT 0;
	INDEX 182;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0183 }
	}
}

WRITE_P0183 LIKE READ_P0183
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0183 }
		REPLY { }
	}
}

VARIABLE P0184
{
	LABEL "P0184 DC Link Regul. Mode|de|P0184 Zwischenkreisregelart|es|P0184 Modo Regulacin Ud ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "With losses|de|mit Verlusten|es|Con prdidas" },
		{ 1, "Without losses|de|ohne Verluste|es|Sin prdidas" },
		{ 2, "Enab/Disab DIx|de|Ein/Aus DIx|es|Hab/Deshab.DIx" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0184
{
	SLOT 0;
	INDEX 183;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0184 }
	}
}

WRITE_P0184 LIKE READ_P0184
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0184 }
		REPLY { }
	}
}

VARIABLE P0185
{
	LABEL "P0185 DC Link Regul. Level|de|P0185 Zwischenkr. Pegel Vek|es|P0185 Nivel Reg. DC Vec   ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0185
{
	SLOT 0;
	INDEX 184;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0185 }
	}
}

WRITE_P0185 LIKE READ_P0185
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0185 }
		REPLY { }
	}
}

VARIABLE P0186
{
	LABEL "P0186 DC Link Prop. Gain|de|P0186 P Zwischenkr. Verst.|es|P0186 Ganancia Prop. Ud";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
}

COMMAND READ_P0186
{
	SLOT 0;
	INDEX 185;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0186 }
	}
}

WRITE_P0186 LIKE READ_P0186
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0186 }
		REPLY { }
	}
}

VARIABLE P0187
{
	LABEL "P0187 DC Link Integral Gain|de|P0187 I Zwischenkr. Verst.|es|P0187 Ganancia Integr. Ud";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0187
{
	SLOT 0;
	INDEX 186;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0187 }
	}
}

WRITE_P0187 LIKE READ_P0187
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0187 }
		REPLY { }
	}
}

VARIABLE P0188
{
	LABEL "P0188 Voltage Proport. Gain|de|P0188 P Ausgansspg. Verst.|es|P0188 Ganan. Prop. V.Salida";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0188
{
	SLOT 0;
	INDEX 187;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0188 }
	}
}

WRITE_P0188 LIKE READ_P0188
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0188 }
		REPLY { }
	}
}

VARIABLE P0189
{
	LABEL "P0189 Voltage Integral Gain|de|P0189 I Ausgansspg. Verst.|es|P0189 Ganan. Int. V.Salida";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0189
{
	SLOT 0;
	INDEX 188;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0189 }
	}
}

WRITE_P0189 LIKE READ_P0189
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0189 }
		REPLY { }
	}
}

VARIABLE P0190
{
	LABEL "P0190 Max. Output Voltage|de|P0190 Max. Ausgangsspannung|es|P0190 Tensin Salida Mxima";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0190
{
	SLOT 0;
	INDEX 189;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0190 }
	}
}

WRITE_P0190 LIKE READ_P0190
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0190 }
		REPLY { }
	}
}

VARIABLE P0200
{
	LABEL "P0200 Password        |de|P0200 Passwort|es|P0200 Seguridad       ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " },
		{ 2, "Change Pass.|de|Pass. ndern|es|Cambiar Seg." }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0200
{
	SLOT 0;
	INDEX 199;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0200 }
	}
}

WRITE_P0200 LIKE READ_P0200
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0200 }
		REPLY { }
	}
}

VARIABLE P0201
{
	LABEL "P0201 Language        |de|P0201 Sprache|es|P0201 Idioma          ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Portugus |de|Portugus |es|Portugus " },
		{ 1, "English|de|English|es|English" },
		{ 2, "Espaol|de|Espaol|es|Espaol" },
		{ 3, "Deutsch|de|Deutsch|es|Deutsch" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0201
{
	SLOT 0;
	INDEX 200;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0201 }
	}
}

WRITE_P0201 LIKE READ_P0201
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0201 }
		REPLY { }
	}
}

VARIABLE P0202
{
	LABEL "P0202 Type of Control|de|P0202 Regelungsart|es|P0202 Tipo de Control ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "V/f 60 Hz |de|U/f 60 Hz|es|V/f 60 Hz " },
		{ 1, "V/f 50 Hz|de|U/f 50 Hz|es|V/f 50 Hz " },
		{ 2, "V/f Adjustable|de|U/f variabel|es|V/f Ajustable" },
		{ 3, "Sensorless|de|Sensorless|es|Sensorless" },
		{ 4, "Encoder   |de|Drehgeber|es|Encoder   " },
		{ 5, "VVW|de|VVW|es|VVW" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0202
{
	SLOT 0;
	INDEX 201;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0202 }
	}
}

WRITE_P0202 LIKE READ_P0202
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0202 }
		REPLY { }
	}
}

VARIABLE P0203
{
	LABEL "P0203 Special Function Sel.|de|P0203 Auswahl Sonderfunk.|es|P0203 Sel. Funcin Especial";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "None      |de|Keine|es|Ninguna   " },
		{ 1, "PID Regulator |de|PID Regler|es|Regulador PID" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0203
{
	SLOT 0;
	INDEX 202;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0203 }
	}
}

WRITE_P0203 LIKE READ_P0203
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0203 }
		REPLY { }
	}
}

VARIABLE P0204
{
	LABEL "P0204 Load/Save Parameters|de|P0204 Lade/Speicher Param.|es|P0204 Carga/Salva Parm.";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 2, "Reset P0045|de|Reset P0045|es|Reset P0045" },
		{ 3, "Reset P0043|de|Reset P0043|es|Reset P0043" },
		{ 4, "Reset P0044|de|Reset P0044|es|Reset P0044" },
		{ 5, "Load 60Hz|de|Lade 60Hz|es|Carga 60Hz" },
		{ 6, "Load 50Hz|de|Lade 50Hz|es|Carga 50Hz" },
		{ 7, "Load User 1|de|Lade Benutz. 1|es|CargaUsuario 1" },
		{ 8, "Load User 2|de|Lade Benutz. 2|es|CargaUsuario 2" },
		{ 9, "Load User 3|de|Lade Benutz. 3|es|CargaUsuario 3" },
		{ 10, "Save User 1|de|Speic. Benutz1|es|SalvaUsuario 1" },
		{ 11, "Save User 2|de|Speic. Benutz2|es|SalvaUsuario 2" },
		{ 12, "Save User 3|de|Speic. Benutz3|es|SalvaUsuario 3" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0204
{
	SLOT 0;
	INDEX 203;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0204 }
	}
}

WRITE_P0204 LIKE READ_P0204
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0204 }
		REPLY { }
	}
}

VARIABLE P0205
{
	LABEL "P0205 Read Parameter Sel. 1|de|P0205 Anzeigeauswahl 1|es|P0205 Sel. Parm. Lectura 1";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer. #|de|Drehz.Sollw. #|es|Ref. Veloc.  #" },
		{ 2, "Motor Speed  #|de|Motordrehz.  #|es|Veloc. Motor #" },
		{ 3, "MotorCurrent #|de|Motorstrom   #|es|Corr. Motor  #" },
		{ 4, "DC Link Volt #|de|ZwischenkrSpg#|es|Tensin CC   #" },
		{ 5, "Motor Freq.  #|de|Motorfrequenz#|es|Frec. Motor  #" },
		{ 6, "MotorVoltage #|de|Motorspg     #|es|Tensin Sal. #" },
		{ 7, "Motor Torque #|de|Motormoment  #|es|Torque Motor #" },
		{ 8, "Output Power #|de|Ausgangsleist#|es|Potencia Sal.#" },
		{ 9, "Process Var. #|de|Prozessvar.  #|es|Var. Proceso #" },
		{ 10, "Setpoint PID #|de|PID Sollwert #|es|Setpoint PID #" },
		{ 11, "Speed Refer. -|de|Drehz.Sollw. -|es|Ref. Veloc.  -" },
		{ 12, "Motor Speed  -|de|Motordrehz.  -|es|Veloc. Motor -" },
		{ 13, "MotorCurrent -|de|Motorstrom   -|es|Corr. Motor  -" },
		{ 14, "DC Link Volt -|de|ZwischenkrSpg-|es|Tensin CC   -" },
		{ 15, "Motor Freq.  -|de|Motorfrequenz-|es|Frec. Motor  -" },
		{ 16, "MotorVoltage -|de|Motorspg     -|es|Tensin Sal. -" },
		{ 17, "Motor Torque -|de|Motormoment  -|es|Torque Motor -" },
		{ 18, "Output Power -|de|Ausgangsleist-|es|Potencia Sal.-" },
		{ 19, "Process Var. -|de|Prozessvar.  -|es|Var. Proceso -" },
		{ 20, "Setpoint PID -|de|PID Sollwert -|es|Setpoint PID -" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0205
{
	SLOT 0;
	INDEX 204;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0205 }
	}
}

WRITE_P0205 LIKE READ_P0205
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0205 }
		REPLY { }
	}
}

VARIABLE P0206
{
	LABEL "P0206 Read Parameter Sel. 2|de|P0206 Anzeigeauswahl 2|es|P0206 Sel. Parm. Lectura 2";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer. #|de|Drehz.Sollw. #|es|Ref. Veloc.  #" },
		{ 2, "Motor Speed  #|de|Motordrehz.  #|es|Veloc. Motor #" },
		{ 3, "MotorCurrent #|de|Motorstrom   #|es|Corr. Motor  #" },
		{ 4, "DC Link Volt #|de|ZwischenkrSpg#|es|Tensin CC   #" },
		{ 5, "Motor Freq.  #|de|Motorfrequenz#|es|Frec. Motor  #" },
		{ 6, "MotorVoltage #|de|Motorspg     #|es|Tensin Sal. #" },
		{ 7, "Motor Torque #|de|Motormoment  #|es|Torque Motor #" },
		{ 8, "Output Power #|de|Ausgangsleist#|es|Potencia Sal.#" },
		{ 9, "Process Var. #|de|Prozessvar.  #|es|Var. Proceso #" },
		{ 10, "Setpoint PID #|de|PID Sollwert #|es|Setpoint PID #" },
		{ 11, "Speed Refer. -|de|Drehz.Sollw. -|es|Ref. Veloc.  -" },
		{ 12, "Motor Speed  -|de|Motordrehz.  -|es|Veloc. Motor -" },
		{ 13, "MotorCurrent -|de|Motorstrom   -|es|Corr. Motor  -" },
		{ 14, "DC Link Volt -|de|ZwischenkrSpg-|es|Tensin CC   -" },
		{ 15, "Motor Freq.  -|de|Motorfrequenz-|es|Frec. Motor  -" },
		{ 16, "MotorVoltage -|de|Motorspg     -|es|Tensin Sal. -" },
		{ 17, "Motor Torque -|de|Motormoment  -|es|Torque Motor -" },
		{ 18, "Output Power -|de|Ausgangsleist-|es|Potencia Sal.-" },
		{ 19, "Process Var. -|de|Prozessvar.  -|es|Var. Proceso -" },
		{ 20, "Setpoint PID -|de|PID Sollwert -|es|Setpoint PID -" }
		DEFAULT_VALUE 3;
	}
}

COMMAND READ_P0206
{
	SLOT 0;
	INDEX 205;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0206 }
	}
}

WRITE_P0206 LIKE READ_P0206
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0206 }
		REPLY { }
	}
}

VARIABLE P0207
{
	LABEL "P0207 Read Parameter Sel. 3|de|P0207 Anzeigeauswahl 3|es|P0207 Sel. Parm. Lectura 3";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer. #|de|Drehz.Sollw. #|es|Ref. Veloc.  #" },
		{ 2, "Motor Speed  #|de|Motordrehz.  #|es|Veloc. Motor #" },
		{ 3, "MotorCurrent #|de|Motorstrom   #|es|Corr. Motor  #" },
		{ 4, "DC Link Volt #|de|ZwischenkrSpg#|es|Tensin CC   #" },
		{ 5, "Motor Freq.  #|de|Motorfrequenz#|es|Frec. Motor  #" },
		{ 6, "MotorVoltage #|de|Motorspg     #|es|Tensin Sal. #" },
		{ 7, "Motor Torque #|de|Motormoment  #|es|Torque Motor #" },
		{ 8, "Output Power #|de|Ausgangsleist#|es|Potencia Sal.#" },
		{ 9, "Process Var. #|de|Prozessvar.  #|es|Var. Proceso #" },
		{ 10, "Setpoint PID #|de|PID Sollwert #|es|Setpoint PID #" },
		{ 11, "Speed Refer. -|de|Drehz.Sollw. -|es|Ref. Veloc.  -" },
		{ 12, "Motor Speed  -|de|Motordrehz.  -|es|Veloc. Motor -" },
		{ 13, "MotorCurrent -|de|Motorstrom   -|es|Corr. Motor  -" },
		{ 14, "DC Link Volt -|de|ZwischenkrSpg-|es|Tensin CC   -" },
		{ 15, "Motor Freq.  -|de|Motorfrequenz-|es|Frec. Motor  -" },
		{ 16, "MotorVoltage -|de|Motorspg     -|es|Tensin Sal. -" },
		{ 17, "Motor Torque -|de|Motormoment  -|es|Torque Motor -" },
		{ 18, "Output Power -|de|Ausgangsleist-|es|Potencia Sal.-" },
		{ 19, "Process Var. -|de|Prozessvar.  -|es|Var. Proceso -" },
		{ 20, "Setpoint PID -|de|PID Sollwert -|es|Setpoint PID -" }
		DEFAULT_VALUE 5;
	}
}

COMMAND READ_P0207
{
	SLOT 0;
	INDEX 206;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0207 }
	}
}

WRITE_P0207 LIKE READ_P0207
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0207 }
		REPLY { }
	}
}

VARIABLE P0208
{
	LABEL "P0208 Ref. Scale Factor|de|P0208 Sollwert Skalafaktor|es|P0208 Factor Escala Ref. ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1800;
		MIN_VALUE 1;
		MAX_VALUE 18000;
	}
}

COMMAND READ_P0208
{
	SLOT 0;
	INDEX 207;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0208 }
	}
}

WRITE_P0208 LIKE READ_P0208
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0208 }
		REPLY { }
	}
}

VARIABLE P0209
{
	LABEL "P0209 Ref. Eng. Unit 1|de|P0209 1. Einheit Sollwert|es|P0209 Unidad Ing. Ref. 1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 114;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0209
{
	SLOT 0;
	INDEX 208;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0209 }
	}
}

WRITE_P0209 LIKE READ_P0209
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0209 }
		REPLY { }
	}
}

VARIABLE P0210
{
	LABEL "P0210 Ref. Eng. Unit 2|de|P0210 2. Einheit Sollwert|es|P0210 Unidad Ing. Ref. 2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 112;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0210
{
	SLOT 0;
	INDEX 209;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0210 }
	}
}

WRITE_P0210 LIKE READ_P0210
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0210 }
		REPLY { }
	}
}

VARIABLE P0211
{
	LABEL "P0211 Ref. Eng. Unit 3|de|P0211 3. Einheit Sollwert|es|P0211 Unidad Ing. Ref. 3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 109;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0211
{
	SLOT 0;
	INDEX 210;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0211 }
	}
}

WRITE_P0211 LIKE READ_P0211
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0211 }
		REPLY { }
	}
}

VARIABLE P0212
{
	LABEL "P0212 Ref. Decimal Point |de|P0212 Sollw. Dezimalpkt.|es|P0212 Punto Decimal Ref. ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "wxyz|de|wxyz|es|wxyz" },
		{ 1, "wxy.z|de|wxy.z|es|wxy.z" },
		{ 2, "wx.yz|de|wx.yz|es|wx.yz" },
		{ 3, "w.xyz|de|w.xyz|es|w.xyz" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0212
{
	SLOT 0;
	INDEX 211;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0212 }
	}
}

WRITE_P0212 LIKE READ_P0212
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0212 }
		REPLY { }
	}
}

VARIABLE P0213
{
	LABEL "P0213 Full Scale Read 1|de|P0213 Anzeigebereich 1|es|P0213 Fondo Escala Lectura1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0213
{
	SLOT 0;
	INDEX 212;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0213 }
	}
}

WRITE_P0213 LIKE READ_P0213
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0213 }
		REPLY { }
	}
}

VARIABLE P0214
{
	LABEL "P0214 Full Scale Read 2|de|P0214 Anzeigebereich 2|es|P0214 Fondo Escala Lectura2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0214
{
	SLOT 0;
	INDEX 213;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0214 }
	}
}

WRITE_P0214 LIKE READ_P0214
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0214 }
		REPLY { }
	}
}

VARIABLE P0215
{
	LABEL "P0215 Full Scale Read 3|de|P0215 Anzeigebereich 3|es|P0215 Fondo Escala Lectura3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0215
{
	SLOT 0;
	INDEX 214;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0215 }
	}
}

WRITE_P0215 LIKE READ_P0215
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0215 }
		REPLY { }
	}
}

VARIABLE P0216
{
	LABEL "P0216 HMI Display Contrast|de|P0216 LCD Kontrast|es|P0216 Contraste Display HMI";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 27;
		MIN_VALUE 0;
		MAX_VALUE 37;
	}
}

COMMAND READ_P0216
{
	SLOT 0;
	INDEX 215;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0216 }
	}
}

WRITE_P0216 LIKE READ_P0216
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0216 }
		REPLY { }
	}
}

VARIABLE P0217
{
	LABEL "P0217 Zero Speed Disable|de|P0217 Stillstandsblockade|es|P0217 Bloqueo por Vel. Nula";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactivo  " },
		{ 1, "On        |de|Ein|es|Activo    " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0217
{
	SLOT 0;
	INDEX 216;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0217 }
	}
}

WRITE_P0217 LIKE READ_P0217
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0217 }
		REPLY { }
	}
}

VARIABLE P0218
{
	LABEL "P0218 Zero Speed Dis. Out|de|P0218 StillstBlock. Grenz.|es|P0218 Salida Bloq. Vel.Nula";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Ref. or Speed|de|Sollw o. Drehz|es|Ref. o Vel." },
		{ 1, "Reference |de|Sollwert|es|Referencia" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0218
{
	SLOT 0;
	INDEX 217;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0218 }
	}
}

WRITE_P0218 LIKE READ_P0218
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0218 }
		REPLY { }
	}
}

VARIABLE P0219
{
	LABEL "P0219 Zero Speed Time|de|P0219 Stillstandblock. Zeit|es|P0219 Tiempo con Vel. Nula";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 999;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0219
{
	SLOT 0;
	INDEX 218;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0219 }
	}
}

WRITE_P0219 LIKE READ_P0219
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0219 }
		REPLY { }
	}
}

VARIABLE P0220
{
	LABEL "P0220 LOC/REM Selection Src|de|P0220 LOC/REM Auswahl|es|P0220 Seleccin LOC/REM   ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Always LOC|de|Immer LOC|es|Siempre LOC" },
		{ 1, "Always REM|de|Immer REM|es|Siempre REM" },
		{ 2, "LR Key LOC|de|Taste LOC|es|Tecla LR (LOC)" },
		{ 3, "LR Key REM|de|Taste REM|es|Tecla LR (REM)" },
		{ 4, "DIx|de|DIx|es|DIx" },
		{ 5, "Serial/USB LOC|de|Seriel/USB LOC|es|Serie/USB LOC " },
		{ 6, "Serial/USB REM|de|Seriel/USB REM|es|Serie/USB REM " },
		{ 7, "Anybus-CC LOC|de|Anybus-CC LOC|es|Anybus-CC LOC" },
		{ 8, "Anybus-CC REM|de|Anybus-CC REM|es|Anybus-CC REM" },
		{ 9, "CANop/DNet LOC|de|CANop/DNet LOC|es|CANop/DNet LOC" },
		{ 10, "CANop/DNet REM|de|CANop/DNet REM|es|CANop/DNet REM" },
		{ 11, "SoftPLC LOC|de|SoftPLC LOC|es|SoftPLC LOC" },
		{ 12, "SoftPLC REM|de|SoftPLC REM|es|SoftPLC REM" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0220
{
	SLOT 0;
	INDEX 219;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0220 }
	}
}

WRITE_P0220 LIKE READ_P0220
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0220 }
		REPLY { }
	}
}

VARIABLE P0221
{
	LABEL "P0221 LOC Reference Sel. |de|P0221 LOC Sollw. Auswahl|es|P0221 Selec. Referencia LOC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Keypad    |de|Fernbedienung|es|HMI" },
		{ 1, "AI1       |de|AI1|es|AI1       " },
		{ 2, "AI2       |de|AI2|es|AI2       " },
		{ 3, "AI3       |de|AI3|es|AI3       " },
		{ 4, "AI4       |de|AI4|es|AI4       " },
		{ 5, "Sum AIs > 0  |de|Summe AIs > 0|es|Suma AIs > 0 " },
		{ 6, "Sum AIs |de|Summe AI|es|Suma AIs   " },
		{ 7, "E.P.      |de|Elekt. Pot.|es|E.P.      " },
		{ 8, "Multispeed|de|Multispeed|es|Multispeed" },
		{ 9, "Serial/USB    |de|Seriell / USB|es|Serie/USB" },
		{ 10, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 11, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0221
{
	SLOT 0;
	INDEX 220;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0221 }
	}
}

WRITE_P0221 LIKE READ_P0221
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0221 }
		REPLY { }
	}
}

VARIABLE P0222
{
	LABEL "P0222 REM Reference Sel. |de|P0222 REM Sollw. Auswahl|es|P0222 Selec. Referencia REM";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Keypad    |de|Fernbedienung|es|HMI" },
		{ 1, "AI1       |de|AI1|es|AI1       " },
		{ 2, "AI2       |de|AI2|es|AI2       " },
		{ 3, "AI3       |de|AI3|es|AI3       " },
		{ 4, "AI4       |de|AI4|es|AI4       " },
		{ 5, "Sum AIs > 0  |de|Summe AIs > 0|es|Suma AIs > 0 " },
		{ 6, "Sum AIs |de|Summe AI|es|Suma AIs   " },
		{ 7, "E.P.      |de|Elekt. Pot.|es|E.P.      " },
		{ 8, "Multispeed|de|Multispeed|es|Multispeed" },
		{ 9, "Serial/USB    |de|Seriell / USB|es|Serie/USB" },
		{ 10, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 11, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0222
{
	SLOT 0;
	INDEX 221;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0222 }
	}
}

WRITE_P0222 LIKE READ_P0222
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0222 }
		REPLY { }
	}
}

VARIABLE P0223
{
	LABEL "P0223 LOC FWD/REV Selection|de|P0223 LOC Drehrichtungswahl|es|P0223 Seleccin Giro LOC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Always FWD|de|Rechtslauf|es|Horario   " },
		{ 1, "Always REV|de|Linkslauf|es|Anti-Horario" },
		{ 2, "FR Key FWD|de|Fernbed. (R)|es|Tecla SG (H)  " },
		{ 3, "FR Key REV|de|Fernbed. (L)|es|Tecla SG (AH) " },
		{ 4, "DIx       |de|DIx       |es|DIx       " },
		{ 5, "Serial/USB FWD|de|Seriell/USB(R)|es|Serie/USB (H) " },
		{ 6, "Serial/USB REV|de|Seriell/USB(L)|es|Serie/USB (AH)" },
		{ 7, "Anybus-CC FWD|de|Anybus-CC (R)|es|Anybus-CC (H)" },
		{ 8, "Anybus-CC REV|de|Anybus-CC (L)|es|Anybus-CC (AH)" },
		{ 9, "CANop/DNet FWD|de|CANop/DNet (R)|es|CANop/DNet (H)" },
		{ 10, "CANop/DNet REV|de|CANop/DNet (L)|es|CANop/DNet(AH)" },
		{ 11, "AI4 Polarity|de|AI4 Polaritt|es|Polaridad AI4" },
		{ 12, "SoftPLC FWD|de|SoftPLC (R)|es|SoftPLC (H)" },
		{ 13, "SoftPLC REV|de|SoftPLC (L)|es|SoftPLC (AH)" },
		{ 14, "AI2 Polarity|de|AI2 Polaritt|es|Polaridad AI2" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0223
{
	SLOT 0;
	INDEX 222;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0223 }
	}
}

WRITE_P0223 LIKE READ_P0223
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0223 }
		REPLY { }
	}
}

VARIABLE P0224
{
	LABEL "P0224 LOC Run/Stop Sel.|de|P0224 LOC Start/Stop Ausw.|es|P0224 Selec. Gira/Para LOC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "I,O Keys  |de|Fernbed. I,O|es|Teclas I,O" },
		{ 1, "DIx       |de|DIx|es|DIx       " },
		{ 2, "Serial/USB    |de|Seriell / USB|es|Serie/USB    " },
		{ 3, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 4, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 5, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0224
{
	SLOT 0;
	INDEX 223;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0224 }
	}
}

WRITE_P0224 LIKE READ_P0224
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0224 }
		REPLY { }
	}
}

VARIABLE P0225
{
	LABEL "P0225 LOC JOG Selection|de|P0225 LOC JOG Auswahl|es|P0225 Seleccin JOG LOC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disable   |de|Aus|es|Inactivo  " },
		{ 1, "JOG Key|de|Fernbedienung|es|Tecla JOG" },
		{ 2, "DIx       |de|DIx       |es|DIx       " },
		{ 3, "Serial/USB    |de|Seriell|es|Serie/USB" },
		{ 4, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 5, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 6, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0225
{
	SLOT 0;
	INDEX 224;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0225 }
	}
}

WRITE_P0225 LIKE READ_P0225
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0225 }
		REPLY { }
	}
}

VARIABLE P0226
{
	LABEL "P0226 REM FWD/REV Sel.|de|P0226 REM Drehrichtung|es|P0226 Seleccin Giro REM  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Always FWD|de|Rechtslauf|es|Horario   " },
		{ 1, "Always REV|de|Linkslauf|es|Anti-Horario" },
		{ 2, "FR Key FWD|de|Fernbed. (R)|es|Tecla SG (H)  " },
		{ 3, "FR Key REV|de|Fernbed. (L)|es|Tecla SG (AH) " },
		{ 4, "DIx       |de|DIx       |es|DIx       " },
		{ 5, "Serial/USB FWD|de|Seriell/USB(R)|es|Serie/USB (H) " },
		{ 6, "Serial/USB REV|de|Seriell/USB(L)|es|Serie/USB (AH)" },
		{ 7, "Anybus-CC FWD|de|Anybus-CC (R)|es|Anybus-CC (H)" },
		{ 8, "Anybus-CC REV|de|Anybus-CC (L)|es|Anybus-CC (AH)" },
		{ 9, "CANop/DNet FWD|de|CANop/DNet (R)|es|CANop/DNet (H)" },
		{ 10, "CANop/DNet REV|de|CANop/DNet (L)|es|CANop/DNet(AH)" },
		{ 11, "AI4 Polarity|de|AI4 Polaritt|es|Polaridad AI4" },
		{ 12, "SoftPLC FWD|de|SoftPLC (R)|es|SoftPLC (H)" },
		{ 13, "SoftPLC REV|de|SoftPLC (L)|es|SoftPLC (AH)" },
		{ 14, "AI2 Polarity|de|AI2 Polaritt|es|Polaridad AI2" }
		DEFAULT_VALUE 4;
	}
}

COMMAND READ_P0226
{
	SLOT 0;
	INDEX 225;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0226 }
	}
}

WRITE_P0226 LIKE READ_P0226
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0226 }
		REPLY { }
	}
}

VARIABLE P0227
{
	LABEL "P0227 REM Run/Stop Sel.|de|P0227 REM Start/Stop Ausw.|es|P0227 Selec. Gira/Para REM";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "I,O Keys  |de|Fernbed. I,O|es|Teclas I,O" },
		{ 1, "DIx       |de|DIx|es|DIx       " },
		{ 2, "Serial/USB    |de|Seriell / USB|es|Serie/USB    " },
		{ 3, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 4, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 5, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0227
{
	SLOT 0;
	INDEX 226;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0227 }
	}
}

WRITE_P0227 LIKE READ_P0227
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0227 }
		REPLY { }
	}
}

VARIABLE P0228
{
	LABEL "P0228 REM JOG Selection |de|P0228 REM JOG Auswahl|es|P0228 Seleccin JOG REM";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disable   |de|Aus|es|Inactivo  " },
		{ 1, "JOG Key|de|Fernbedienung|es|Tecla JOG" },
		{ 2, "DIx       |de|DIx       |es|DIx       " },
		{ 3, "Serial/USB    |de|Seriell / USB|es|Serie/USB    " },
		{ 4, "Anybus-CC|de|Anybus-CC|es|Anybus-CC" },
		{ 5, "CANop/DNet|de|CANop/DNet|es|CANop/DNet" },
		{ 6, "SoftPLC|de|SoftPLC|es|SoftPLC" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0228
{
	SLOT 0;
	INDEX 227;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0228 }
	}
}

WRITE_P0228 LIKE READ_P0228
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0228 }
		REPLY { }
	}
}

VARIABLE P0229
{
	LABEL "P0229 Stop Mode Selection|de|P0229 Auswahl Stopmodus|es|P0229 Seleccin de Parada";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Ramp to Stop|de|Start/Stop|es|Por Rampa" },
		{ 1, "Coast to Stop|de|Gen. Abschalt.|es|Por Inercia" },
		{ 2, "Fast Stop |de|Schnellstop|es|Parada Rpida" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0229
{
	SLOT 0;
	INDEX 228;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0229 }
	}
}

WRITE_P0229 LIKE READ_P0229
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0229 }
		REPLY { }
	}
}

VARIABLE P0230
{
	LABEL "P0230 Dead Zone (AIs)|de|P0230 Totzone (AIs)|es|P0230 Zona Muerta     ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0230
{
	SLOT 0;
	INDEX 229;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0230 }
	}
}

WRITE_P0230 LIKE READ_P0230
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0230 }
		REPLY { }
	}
}

VARIABLE P0231
{
	LABEL "P0231 AI1 Signal Function|de|P0231 AI1 Signalfunktion|es|P0231 Funcin Seal AI1  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Veloc." },
		{ 1, "No Ramp Ref.|de|N* ohne Rampe|es|N* sin Rampa" },
		{ 2, "Max.Torque Cur|de|Max.Momentstr.|es|Mx.Cor.Torque" },
		{ 3, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 4, "PTC|de|PTC|es|PTC" },
		{ 5, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 6, "Not Used  |de|Ohne Funktion|es|Sin Funcin " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0231
{
	SLOT 0;
	INDEX 230;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0231 }
	}
}

WRITE_P0231 LIKE READ_P0231
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0231 }
		REPLY { }
	}
}

VARIABLE P0232
{
	LABEL "P0232 AI1 Gain|de|P0232 AI1 Verstrkung|es|P0232 Ganancia Entrada AI1 ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0232
{
	SLOT 0;
	INDEX 231;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0232 }
	}
}

WRITE_P0232 LIKE READ_P0232
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0232 }
		REPLY { }
	}
}

VARIABLE P0233
{
	LABEL "P0233 AI1 Signal Type |de|P0233 AI1 Signaltyp|es|P0233 Seal Entrada AI1  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA|es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA|es|20 a 4 mA " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0233
{
	SLOT 0;
	INDEX 232;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0233 }
	}
}

WRITE_P0233 LIKE READ_P0233
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0233 }
		REPLY { }
	}
}

VARIABLE P0234
{
	LABEL "P0234 AI1 Offset      |de|P0234 AI1 Offset|es|P0234 Offset Entrada AI1 ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0234
{
	SLOT 0;
	INDEX 233;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0234 }
	}
}

WRITE_P0234 LIKE READ_P0234
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0234 }
		REPLY { }
	}
}

VARIABLE P0235
{
	LABEL "P0235 AI1 Filter|de|P0235 AI1 Filter|es|P0235 Filtro Entrada AI1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0235
{
	SLOT 0;
	INDEX 234;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0235 }
	}
}

WRITE_P0235 LIKE READ_P0235
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0235 }
		REPLY { }
	}
}

VARIABLE P0236
{
	LABEL "P0236 AI2 Signal Function|de|P0236 AI2 Signalfunktion|es|P0236 Funcin Seal AI2  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Veloc." },
		{ 1, "No Ramp Ref.|de|N* ohne Rampe|es|N* sin Rampa" },
		{ 2, "Max.Torque Cur|de|Max.Momentstr.|es|Mx.Cor.Torque" },
		{ 3, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 4, "PTC|de|PTC|es|PTC" },
		{ 5, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 6, "Not Used  |de|Ohne Funktion|es|Sin Funcin " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0236
{
	SLOT 0;
	INDEX 235;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0236 }
	}
}

WRITE_P0236 LIKE READ_P0236
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0236 }
		REPLY { }
	}
}

VARIABLE P0237
{
	LABEL "P0237 AI2 Gain        |de|P0237 AI2 Verstrkung|es|P0237 Ganancia Entrada AI2 ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0237
{
	SLOT 0;
	INDEX 236;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0237 }
	}
}

WRITE_P0237 LIKE READ_P0237
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0237 }
		REPLY { }
	}
}

VARIABLE P0238
{
	LABEL "P0238 AI2 Signal Type |de|P0238 AI2 Signaltyp|es|P0238 Seal Entrada AI2  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA|es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA|es|20 a 4 mA " },
		{ 4, "-10 to +10V|de|-10 bis +10V|es|-10 a +10V" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0238
{
	SLOT 0;
	INDEX 237;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0238 }
	}
}

WRITE_P0238 LIKE READ_P0238
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0238 }
		REPLY { }
	}
}

VARIABLE P0239
{
	LABEL "P0239 AI2 Offset      |de|P0239 AI2 Offset|es|P0239 Offset Entrada AI2 ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0239
{
	SLOT 0;
	INDEX 238;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0239 }
	}
}

WRITE_P0239 LIKE READ_P0239
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0239 }
		REPLY { }
	}
}

VARIABLE P0240
{
	LABEL "P0240 AI2 Filter|de|P0240 AI2 Filter|es|P0240 Filtro Entrada AI2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0240
{
	SLOT 0;
	INDEX 239;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0240 }
	}
}

WRITE_P0240 LIKE READ_P0240
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0240 }
		REPLY { }
	}
}

VARIABLE P0241
{
	LABEL "P0241 AI3 Signal Function|de|P0241 AI3 Signalfunktion|es|P0241 Funcin Seal AI3";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Veloc." },
		{ 1, "No Ramp Ref.|de|N* ohne Rampe|es|N* sin Rampa" },
		{ 2, "Max.Torque Cur|de|Max.Momentstr.|es|Mx.Cor.Torque" },
		{ 3, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 4, "PTC|de|PTC|es|PTC" },
		{ 5, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 6, "Not Used  |de|Ohne Funktion|es|Sin Funcin " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0241
{
	SLOT 0;
	INDEX 240;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0241 }
	}
}

WRITE_P0241 LIKE READ_P0241
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0241 }
		REPLY { }
	}
}

VARIABLE P0242
{
	LABEL "P0242 AI3 Gain        |de|P0242 AI3 Verstrkung|es|P0242 Ganancia Entrada AI3 ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0242
{
	SLOT 0;
	INDEX 241;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0242 }
	}
}

WRITE_P0242 LIKE READ_P0242
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0242 }
		REPLY { }
	}
}

VARIABLE P0243
{
	LABEL "P0243 AI3 Signal Type |de|P0243 AI3 Signaltyp|es|P0243 Seal Entrada AI3  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA|es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA|es|20 a 4 mA " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0243
{
	SLOT 0;
	INDEX 242;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0243 }
	}
}

WRITE_P0243 LIKE READ_P0243
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0243 }
		REPLY { }
	}
}

VARIABLE P0244
{
	LABEL "P0244 AI3 Offset      |de|P0244 AI3 Offset|es|P0244 Offset Entrada AI3 ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0244
{
	SLOT 0;
	INDEX 243;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0244 }
	}
}

WRITE_P0244 LIKE READ_P0244
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0244 }
		REPLY { }
	}
}

VARIABLE P0245
{
	LABEL "P0245 AI3 Filter|de|P0245 AI3 Filter|es|P0245 Filtro Entrada AI3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0245
{
	SLOT 0;
	INDEX 244;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0245 }
	}
}

WRITE_P0245 LIKE READ_P0245
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0245 }
		REPLY { }
	}
}

VARIABLE P0246
{
	LABEL "P0246 AI4 Signal Function|de|P0246 AI4Signalfunkt.|es|P0246 Funcin Seal AI4";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Veloc." },
		{ 1, "No Ramp Ref.|de|N* ohne Rampe|es|N* sin Rampa" },
		{ 2, "Max.Torque Cur|de|Max.Momentstr.|es|Mx.Cor.Torque" },
		{ 3, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 4, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 5, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 6, "Not Used  |de|Ohne Funktion|es|Sin Funcin " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0246
{
	SLOT 0;
	INDEX 245;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0246 }
	}
}

WRITE_P0246 LIKE READ_P0246
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0246 }
		REPLY { }
	}
}

VARIABLE P0247
{
	LABEL "P0247 AI4 Gain        |de|P0247 AI4 Verstrkung|es|P0247 Ganancia Entrada AI4 ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0247
{
	SLOT 0;
	INDEX 246;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0247 }
	}
}

WRITE_P0247 LIKE READ_P0247
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0247 }
		REPLY { }
	}
}

VARIABLE P0248
{
	LABEL "P0248 AI4 Signal Type |de|P0248 AI4 Signaltyp|es|P0248 Seal Entrada AI4  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA|es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA|es|20 a 4 mA " },
		{ 4, "-10 to +10 V|de|-10 bis +10V|es|-10 a +10V" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0248
{
	SLOT 0;
	INDEX 247;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0248 }
	}
}

WRITE_P0248 LIKE READ_P0248
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0248 }
		REPLY { }
	}
}

VARIABLE P0249
{
	LABEL "P0249 AI4 Offset      |de|P0249 AI4 Offset|es|P0249 Offset Entrada AI4 ";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0249
{
	SLOT 0;
	INDEX 248;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0249 }
	}
}

WRITE_P0249 LIKE READ_P0249
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0249 }
		REPLY { }
	}
}

VARIABLE P0250
{
	LABEL "P0250 AI4 Filter|de|P0250 AI4 Filter|es|P0250 Filtro Entrada AI4";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0250
{
	SLOT 0;
	INDEX 249;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0250 }
	}
}

WRITE_P0250 LIKE READ_P0250
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0250 }
		REPLY { }
	}
}

VARIABLE P0251
{
	LABEL "P0251 AO1 Function    |de|P0251 AO1 Funktion|es|P0251 Funcin Salida AO1  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Velocidad" },
		{ 1, "Total Ref.|de|Gesamtsollwert|es|Ref. Total" },
		{ 2, "Real Speed|de|Istdrehzahl|es|Velocidad Real" },
		{ 3, "Torque Cur.Ref|de|Momentsollw.|es|Ref.Cor.Torque" },
		{ 4, "Torque Current|de|Momentstrom|es|Corr. Torque" },
		{ 5, "Output Current|de|Ausgangsstrom|es|Corr. Salida" },
		{ 6, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 7, "Active Current|de|Wirkstrom|es|Corr. Activa" },
		{ 8, "Output Power |de|Ausgangsleist.|es|Pot. Salida" },
		{ 9, "PID Setpoint|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "Torque Cur.> 0|de|Momentstrom >0|es|Corr. Torque>0" },
		{ 11, "Motor Torque|de|Motormoment|es|Torque Motor " },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 13, "PTC|de|PTC|es|PTC" },
		{ 14, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 15, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 16, "Motor Ixt|de|Motor I x t|es|Ixt Motor" },
		{ 17, "Encoder Speed|de|Drehgeb.Geschw|es|Veloc. Encoder" },
		{ 18, "P0696 Value|de|P0696 Wert|es|ContenidoP0696" },
		{ 19, "P0697 Value|de|P0697 Wert|es|ContenidoP0697" },
		{ 20, "P0698 Value|de|P0698 Wert|es|ContenidoP0698" },
		{ 21, "P0699 Value|de|P0699 Wert|es|ContenidoP0699" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0251
{
	SLOT 0;
	INDEX 250;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0251 }
	}
}

WRITE_P0251 LIKE READ_P0251
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0251 }
		REPLY { }
	}
}

VARIABLE P0252
{
	LABEL "P0252 AO1 Gain        |de|P0252 AO1 Verstrkung|es|P0252 Ganancia Salida AO1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0252
{
	SLOT 0;
	INDEX 251;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0252 }
	}
}

WRITE_P0252 LIKE READ_P0252
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0252 }
		REPLY { }
	}
}

VARIABLE P0253
{
	LABEL "P0253 AO1 Signal Type |de|P0253 AO1 Signaltyp|es|P0253 Seal Salida AO1  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA |es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA |es|20 a 4 mA " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0253
{
	SLOT 0;
	INDEX 252;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0253 }
	}
}

WRITE_P0253 LIKE READ_P0253
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0253 }
		REPLY { }
	}
}

VARIABLE P0254
{
	LABEL "P0254 AO2 Function    |de|P0254 AO2 Funktion|es|P0254 Funcin Salida AO2  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Velocidad" },
		{ 1, "Total Ref.|de|Gesamtsollwert|es|Ref. Total" },
		{ 2, "Real Speed|de|Istdrehzahl|es|Velocidad Real" },
		{ 3, "Torque Cur.Ref|de|Momentsollw.|es|Ref.Cor.Torque" },
		{ 4, "Torque Current|de|Momentstrom|es|Corr. Torque" },
		{ 5, "Output Current|de|Ausgangsstrom|es|Corr. Salida" },
		{ 6, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 7, "Active Current|de|Wirkstrom|es|Corr. Activa" },
		{ 8, "Output Power |de|Ausgangsleist.|es|Pot. Salida" },
		{ 9, "PID Setpoint|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "Torque Cur.> 0|de|Momentstrom >0|es|Corr. Torque>0" },
		{ 11, "Motor Torque|de|Motormoment|es|Torque Motor " },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 13, "PTC|de|PTC|es|PTC" },
		{ 14, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 15, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 16, "Motor Ixt|de|Motor I x t|es|Ixt Motor" },
		{ 17, "Encoder Speed|de|Drehgeb.Geschw|es|Veloc. Encoder" },
		{ 18, "P0696 Value|de|P0696 Wert|es|ContenidoP0696" },
		{ 19, "P0697 Value|de|P0697 Wert|es|ContenidoP0697" },
		{ 20, "P0698 Value|de|P0698 Wert|es|ContenidoP0698" },
		{ 21, "P0699 Value|de|P0699 Wert|es|ContenidoP0699" }
		DEFAULT_VALUE 5;
	}
}

COMMAND READ_P0254
{
	SLOT 0;
	INDEX 253;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0254 }
	}
}

WRITE_P0254 LIKE READ_P0254
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0254 }
		REPLY { }
	}
}

VARIABLE P0255
{
	LABEL "P0255 AO2 Gain        |de|P0255 AO2 Verstrkung|es|P0255 Ganancia Salida AO2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0255
{
	SLOT 0;
	INDEX 254;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0255 }
	}
}

WRITE_P0255 LIKE READ_P0255
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0255 }
		REPLY { }
	}
}

VARIABLE P0256
{
	LABEL "P0256 AO2 Signal Type |de|P0256 AO2 Signaltyp|es|P0256 Seal Salida AO2";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 10V/20mA|de|0 bis 10V/20mA|es|0 a 10V/20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20mA |es|4 a 20 mA " },
		{ 2, "10V/20mA to 0|de|10V/20mA bis 0|es|10V/20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4mA |es|20 a 4 mA " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0256
{
	SLOT 1;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0256 }
	}
}

WRITE_P0256 LIKE READ_P0256
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0256 }
		REPLY { }
	}
}

VARIABLE P0257
{
	LABEL "P0257 AO3 Function    |de|P0257 AO3 Funktion|es|P0257 Funcin Salida AO3 ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Velocidad" },
		{ 1, "Total Ref.|de|Gesamtsollwert|es|Ref. Total" },
		{ 2, "Real Speed|de|Istdrehzahl|es|Velocidad Real" },
		{ 3, "Torque Cur.Ref|de|Momentsollw.|es|Ref.Cor.Torque" },
		{ 4, "Torque Current|de|Momentstrom|es|Corr. Torque" },
		{ 5, "Output Current|de|Ausgangsstrom|es|Corr. Salida" },
		{ 6, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 7, "Active Current|de|Wirkstrom|es|Corr. Activa" },
		{ 8, "Output Power |de|Ausgangsleist.|es|Pot. Salida" },
		{ 9, "PID Setpoint|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "Torque Cur.> 0|de|Momentstrom >0|es|Corr. Torque>0" },
		{ 11, "Motor Torque|de|Motormoment|es|Torque Motor " },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 13, "Not Used  |de|Ohne Funktion|es|PTC" },
		{ 14, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 15, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 16, "Motor Ixt|de|Motor I x t|es|Ixt Motor" },
		{ 17, "Encoder Speed|de|Drehgeb.Geschw|es|Veloc. Encoder" },
		{ 18, "P0696 Value|de|P0696 Wert|es|ContenidoP0696" },
		{ 19, "P0697 Value|de|P0697 Wert|es|ContenidoP0697" },
		{ 20, "P0698 Value|de|P0698 Wert|es|ContenidoP0698" },
		{ 21, "P0699 Value|de|P0699 Wert|es|ContenidoP0699" },
		{ 22, "Id* Current|de|Id* Strom|es|Corriente Id*" },
		{ 23, "Iq* Current|de|Iq* Strom|es|Corriente Iq*" },
		{ 24, "Id Current|de|Id Strom|es|Corriente Id" },
		{ 25, "Iq Current|de|Iq Strom|es|Corriente Iq" },
		{ 26, "Isa Current|de|Isa Strom|es|Corriente Isa" },
		{ 27, "Isb Current|de|Isb Strom|es|Corriente Isb" },
		{ 28, "Idq Current|de|Idq Strom|es|Corriente Idq" },
		{ 29, "Imr* Current|de|Imr* Strom|es|Corriente Imr*" },
		{ 30, "Imr Current|de|Imr Strom|es|Corriente Imr" },
		{ 31, "Ud Voltage|de|Ud Spannung|es|Tensin Ud" },
		{ 32, "Uq Voltage|de|Uq Spannung|es|Tensin Uq" },
		{ 33, "Flux Angle|de|Flusswinkel|es|ngulo Flujo" },
		{ 34, "Usal_rec|de|Usal_rec|es|Usal_rec" },
		{ 35, "Ixt Output|de|I x t Ausgang|es|Salida Ixt" },
		{ 36, "Rotor speed|de|Rotorgeschw.|es|Veloc. Rotor" },
		{ 37, "Phi Angle|de|Winkel Phi|es|ngulo Phi" },
		{ 38, "Usd_rec|de|Usd_rec|es|Usd_rec" },
		{ 39, "Usq_rec|de|Usq_rec|es|Usq_rec" },
		{ 40, "Flux_a1|de|Fluss_a1|es|Flux_a1" },
		{ 41, "Flux_b1|de|Fluss_b1|es|Flux_b1" },
		{ 42, "Stator Speed|de|Statorgeschw.|es|Vel. Estator" },
		{ 43, "Slip|de|Schlupf|es|Deslizamiento" },
		{ 44, "Flux reference|de|Flusssollwert|es|Ref. de flujo" },
		{ 45, "Real Flux|de|Istfluss|es|Flujo real" },
		{ 46, "Igen = Reg_ud|de|Igen = Reg_ud|es|Igen = Reg_ud" },
		{ 47, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 48, "Total Curr wIt|de|Gesamtstr. wIt|es|Cor. Total wIt" },
		{ 49, "Is Current|de|Is Strom|es|Corriente Is" },
		{ 50, "Iactive|de|Iaktiv|es|Iactiva" },
		{ 51, "sR|de|sR|es|sR" },
		{ 52, "TR|de|TR|es|TR" },
		{ 53, "PfeR|de|PfeR|es|PfeR" },
		{ 54, "Pfe |de|Pfe |es|Pfe " },
		{ 55, "Pgap|de|Pgap|es|Pgap" },
		{ 56, "TL|de|TL|es|TL" },
		{ 57, "Fslip |de|Fslip |es|Fslip " },
		{ 58, "m_nc|de|m_nc|es|m_nc" },
		{ 59, "m_AST|de|m_AST|es|m_AST" },
		{ 60, "m_|de|m_|es|m_" },
		{ 61, "m_LINHA|de|m_LINHA|es|m_LINHA" },
		{ 62, "m_BOOST|de|m_BOOST|es|m_BOOST" },
		{ 63, "SINPHI|de|SINPHI|es|SINPHI" },
		{ 64, "SINPHI120|de|SINPHI120|es|SINPHI120" },
		{ 65, "Ib|de|Ib|es|Ib" },
		{ 66, "Ic|de|Ic|es|Ic" },
		{ 67, "It|de|It|es|It" },
		{ 68, "MOD_I|de|MOD_I|es|MOD_I" },
		{ 69, "ZERO_V|de|ZERO_V|es|ZERO_V" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0257
{
	SLOT 1;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0257 }
	}
}

WRITE_P0257 LIKE READ_P0257
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0257 }
		REPLY { }
	}
}

VARIABLE P0258
{
	LABEL "P0258 AO3 Gain        |de|P0258 AO3 Verstrkung|es|P0258 Ganancia Salida AO3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0258
{
	SLOT 1;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0258 }
	}
}

WRITE_P0258 LIKE READ_P0258
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0258 }
		REPLY { }
	}
}

VARIABLE P0259
{
	LABEL "P0259 AO3 Signal Type |de|P0259 AO3 Signaltyp|es|P0259 Seal Salida AO3  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 20 mA|de|0 bis 20 mA|es|0 a 20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20 mA |es|4 a 20 mA " },
		{ 2, "20 to 0 mA|de|20 bis 0 mA|es|20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4 mA |es|20 a 4 mA " },
		{ 4, "0 to 10 V|de|0 bis 10 V|es|0 a 10 V" },
		{ 5, "10 to 0 V|de|10 bis 0 V|es|10 a 0 V" },
		{ 6, "-10 to +10V|de|-10 bis +10V|es|-10 a +10V" }
		DEFAULT_VALUE 4;
	}
}

COMMAND READ_P0259
{
	SLOT 1;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0259 }
	}
}

WRITE_P0259 LIKE READ_P0259
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0259 }
		REPLY { }
	}
}

VARIABLE P0260
{
	LABEL "P0260 AO4 Function    |de|P0260 AO4 Funktion|es|P0260 Funcin Salida AO4 ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Speed Ref.|de|Drehzahlsollw.|es|Ref. Velocidad" },
		{ 1, "Total Ref.|de|Gesamtsollwert|es|Ref. Total" },
		{ 2, "Real Speed|de|Istdrehzahl|es|Velocidad Real" },
		{ 3, "Torque Cur.Ref|de|Momentsollw.|es|Ref.Cor.Torque" },
		{ 4, "Torque Current|de|Momentstrom|es|Corr. Torque" },
		{ 5, "Output Current|de|Ausgangsstrom|es|Corr. Salida" },
		{ 6, "Process Var.|de|Prozess Var.|es|Var. Proceso" },
		{ 7, "Active Current|de|Wirkstrom|es|Corr. Activa" },
		{ 8, "Output Power |de|Ausgangsleist.|es|Pot. Salida" },
		{ 9, "PID Setpoint|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "Torque Cur.> 0|de|Momentstrom >0|es|Corr. Torque>0" },
		{ 11, "Motor Torque|de|Motormoment|es|Torque Motor " },
		{ 12, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 13, "Not Used  |de|Ohne Funktion|es|PTC" },
		{ 14, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 15, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 16, "Motor Ixt|de|I x t Motor|es|Ixt Motor" },
		{ 17, "Encoder Speed|de|Drehgeb.Geschw|es|Veloc. Encoder" },
		{ 18, "P0696 Value|de|P0696 Wert|es|ContenidoP0696" },
		{ 19, "P0697 Value|de|P0697 Wert|es|ContenidoP0697" },
		{ 20, "P0698 Value|de|P0698 Wert|es|ContenidoP0698" },
		{ 21, "P0699 Value|de|P0699 Wert|es|ContenidoP0699" },
		{ 22, "Id* Current|de|Id* Strom|es|Corriente Id*" },
		{ 23, "Iq* Current|de|Iq* Strom|es|Corriente Iq*" },
		{ 24, "Id Current|de|Id Strom|es|Corriente Id" },
		{ 25, "Iq Current|de|Iq Strom|es|Corriente Iq" },
		{ 26, "Isa Current|de|Isa Strom|es|Corriente Isa" },
		{ 27, "Isb Current|de|Isb Strom|es|Corriente Isb" },
		{ 28, "Idq Current|de|Idq Strom|es|Corriente Idq" },
		{ 29, "Imr* Current|de|Imr* Strom|es|Corriente Imr*" },
		{ 30, "Imr Current|de|Imr Strom|es|Corriente Imr" },
		{ 31, "Ud Voltage|de|Ud Spannung|es|Tensin Ud" },
		{ 32, "Uq Voltage|de|Uq Spannung|es|Tensin Uq" },
		{ 33, "Flux Angle|de|Flusswinkel|es|ngulo Flujo" },
		{ 34, "Usal_rec|de|Usal_rec|es|Usal_rec" },
		{ 35, "Ixt Output|de|I x t Ausgang|es|Salida Ixt" },
		{ 36, "Rotor speed|de|Rotorgeschw.|es|Veloc. Rotor" },
		{ 37, "Phi Angle|de|Winkel Phi|es|ngulo Phi" },
		{ 38, "Usd_rec|de|Usd_rec|es|Usd_rec" },
		{ 39, "Usq_rec|de|Usq_rec|es|Usq_rec" },
		{ 40, "Flux_a1|de|Fluss_a1|es|Flux_a1" },
		{ 41, "Flux_b1|de|Fluss_b1|es|Flux_b1" },
		{ 42, "Stator Speed|de|Statorgeschw.|es|Vel. Estator" },
		{ 43, "Slip|de|Schlupf|es|Deslizamiento" },
		{ 44, "Flux reference|de|Flusssollwert|es|Ref. de flujo" },
		{ 45, "Real Flux|de|Istfluss|es|Flujo real" },
		{ 46, "Igen = Reg_ud|de|Igen = Reg_ud|es|Igen = Reg_ud" },
		{ 47, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 48, "Total Curr wIt|de|Gesamtstr. wIt|es|Cor. Total wIt" },
		{ 49, "Is Current|de|Is Strom|es|Corriente Is" },
		{ 50, "Iactive|de|Iaktiv|es|Iactiva" },
		{ 51, "sR|de|sR|es|sR" },
		{ 52, "TR|de|TR|es|TR" },
		{ 53, "PfeR|de|PfeR|es|PfeR" },
		{ 54, "Pfe |de|Pfe |es|Pfe " },
		{ 55, "Pgap|de|Pgap|es|Pgap" },
		{ 56, "TL|de|TL|es|TL" },
		{ 57, "Fslip |de|Fslip |es|Fslip " },
		{ 58, "m_nc|de|m_nc|es|m_nc" },
		{ 59, "m_AST|de|m_AST|es|m_AST" },
		{ 60, "m_|de|m_|es|m_" },
		{ 61, "m_LINHA|de|m_LINHA|es|m_LINHA" },
		{ 62, "m_BOOST|de|m_BOOST|es|m_BOOST" },
		{ 63, "SINPHI|de|SINPHI|es|SINPHI" },
		{ 64, "SINPHI120|de|SINPHI120|es|SINPHI120" },
		{ 65, "Ib|de|Ib|es|Ib" },
		{ 66, "Ic|de|Ic|es|Ic" },
		{ 67, "It|de|It|es|It" },
		{ 68, "MOD_I|de|MOD_I|es|MOD_I" },
		{ 69, "ZERO_V|de|ZERO_V|es|ZERO_V" }
		DEFAULT_VALUE 5;
	}
}

COMMAND READ_P0260
{
	SLOT 1;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0260 }
	}
}

WRITE_P0260 LIKE READ_P0260
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0260 }
		REPLY { }
	}
}

VARIABLE P0261
{
	LABEL "P0261 AO4 Gain        |de|P0261 AO4 Verstrkung|es|P0261 Ganancia Salida AO4";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0261
{
	SLOT 1;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0261 }
	}
}

WRITE_P0261 LIKE READ_P0261
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0261 }
		REPLY { }
	}
}

VARIABLE P0262
{
	LABEL "P0262 AO4 Signal Type |de|P0262 AO4 Signaltyp|es|P0262 Seal Salida AO4  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0 to 20 mA|de|0 bis 20 mA|es|0 a 20mA" },
		{ 1, "4 to 20 mA |de|4 bis 20 mA |es|4 a 20 mA " },
		{ 2, "20 to 0 mA|de|20 bis 0 mA|es|20mA a 0" },
		{ 3, "20 to 4 mA |de|20 bis 4 mA |es|20 a 4 mA " },
		{ 4, "0 to 10 V|de|0 bis 10 V|es|0 a 10 V" },
		{ 5, "10 to 0 V|de|10 bis 0 V|es|10 a 0 V" },
		{ 6, "-10 to +10V|de|-10 bis +10V|es|-10 a +10V" }
		DEFAULT_VALUE 4;
	}
}

COMMAND READ_P0262
{
	SLOT 1;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0262 }
	}
}

WRITE_P0262 LIKE READ_P0262
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0262 }
		REPLY { }
	}
}

VARIABLE P0263
{
	LABEL "P0263 DI1 Function    |de|P0263 DI1 Funktion|es|P0263 Funcin Entrada DI1  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0263
{
	SLOT 1;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0263 }
	}
}

WRITE_P0263 LIKE READ_P0263
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0263 }
		REPLY { }
	}
}

VARIABLE P0264
{
	LABEL "P0264 DI2 Function    |de|P0264 DI2 Funktion|es|P0264 Funcin Entrada DI2  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 8;
	}
}

COMMAND READ_P0264
{
	SLOT 1;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0264 }
	}
}

WRITE_P0264 LIKE READ_P0264
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0264 }
		REPLY { }
	}
}

VARIABLE P0265
{
	LABEL "P0265 DI3 Function    |de|P0265 DI3 Funktion|es|P0265 Funcin Entrada DI3  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0265
{
	SLOT 1;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0265 }
	}
}

WRITE_P0265 LIKE READ_P0265
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0265 }
		REPLY { }
	}
}

VARIABLE P0266
{
	LABEL "P0266 DI4 Function    |de|P0266 DI4 Funktion|es|P0266 Funcin Entrada DI4  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Multispeed|de|Ohne Funktion|es|Multispeed" },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0266
{
	SLOT 1;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0266 }
	}
}

WRITE_P0266 LIKE READ_P0266
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0266 }
		REPLY { }
	}
}

VARIABLE P0267
{
	LABEL "P0267 DI5 Function    |de|P0267 DI5 Funktion|es|P0267 Funcin Entrada DI5  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Multispeed|de|Ohne Funktion|es|Multispeed" },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 10;
	}
}

COMMAND READ_P0267
{
	SLOT 1;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0267 }
	}
}

WRITE_P0267 LIKE READ_P0267
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0267 }
		REPLY { }
	}
}

VARIABLE P0268
{
	LABEL "P0268 DI6 Function    |de|P0268 DI6 Funktion|es|P0268 Funcin Entrada DI6 ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Multispeed|de|Ohne Funktion|es|Multispeed" },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 14;
	}
}

COMMAND READ_P0268
{
	SLOT 1;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0268 }
	}
}

WRITE_P0268 LIKE READ_P0268
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0268 }
		REPLY { }
	}
}

VARIABLE P0269
{
	LABEL "P0269 DI7 Function    |de|P0269 DI7 Funktion|es|P0269 Funcin Entrada DI7  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Veloc./Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Progr. Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0269
{
	SLOT 1;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0269 }
	}
}

WRITE_P0269 LIKE READ_P0269
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0269 }
		REPLY { }
	}
}

VARIABLE P0270
{
	LABEL "P0270 DI8 Function    |de|P0270 DI8 Funktion|es|P0270 Funcin Entrada DI8  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Run/Stop  |de|Start / Stop|es|Gira/Para " },
		{ 2, "General Enable|de|Freigabe|es|Hab. General" },
		{ 3, "Fast Stop |de|Schnellstop|es|Parada Rpida" },
		{ 4, "FWD Run   |de|Rechtslauf|es|Avance    " },
		{ 5, "REV Run   |de|Linkslauf|es|Retroceso " },
		{ 6, "3-Wire Start|de|Start|es|Start     " },
		{ 7, "3-Wire Stop |de|Stop|es|Stop      " },
		{ 8, "FWD/REV   |de|Drehrichtung|es|Sentido Giro " },
		{ 9, "LOC/REM   |de|LOC / REM|es|LOC/REM   " },
		{ 10, "JOG       |de|JOG|es|JOG       " },
		{ 11, "Increase EP|de|EP Beschleunig|es|Acelera EP" },
		{ 12, "Decrease EP|de|EP Bremsen |es|Desacelera EP" },
		{ 13, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 14, "Ramp 2    |de|2. Rampe|es|2a. Rampa  " },
		{ 15, "Speed/Torque|de|Drehz./Moment|es|Vel/Torque" },
		{ 16, "JOG+|de|JOG+|es|JOG+    " },
		{ 17, "JOG-|de|JOG-|es|JOG-    " },
		{ 18, "No Ext. Alarm|de|Ohne ext. Ala.|es|Sin Alarma Ext" },
		{ 19, "No Ext. Fault|de|Ohne ext. Feh.|es|Sin Falla Ext." },
		{ 20, "Reset|de|Reset|es|Reset     " },
		{ 21, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 22, "Manual/Auto|de|Manual / Autom|es|Manual/Autom." },
		{ 23, "Motor Thermis.|de|Motorthermist.|es|Termist. Motor" },
		{ 24, "Disab.FlyStart|de|FliegSt Sperre|es|Deshab. FS" },
		{ 25, "DC Link Regul.|de|ZwKrSpg Reg.|es|Regul. Barr.CC" },
		{ 26, "Parametriz.Off|de|Programm Aus|es|Bloquea Prog." },
		{ 27, "Load User 1/2|de|Lade Ben. 1/2|es|Carga Us. 1/2" },
		{ 28, "Load User 3|de|Lade Benutz. 3|es|Carga Us. 3" },
		{ 29, "DO2 Timer|de|Timer DO2|es|Temporiz. DO2" },
		{ 30, "DO3 Timer|de|Timer DO3|es|Temporiz. DO3" },
		{ 31, "Trace Function|de|Trace-Funktion|es|Funcin Trace" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0270
{
	SLOT 1;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0270 }
	}
}

WRITE_P0270 LIKE READ_P0270
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0270 }
		REPLY { }
	}
}

VARIABLE P0275
{
	LABEL "P0275 DO1 Function (RL1)|de|P0275 DO1 Funktion (RL1)|es|P0275 Funcin de DO1 (RL1)";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "N* > Nx   |de|N* > Nx|es|N* > Nx   " },
		{ 2, "N > Nx    |de|N > Nx|es|N > Nx    " },
		{ 3, "N < Ny    |de|N < Ny|es|N < Ny    " },
		{ 4, "N = N*    |de|N = N*|es|N = N*    " },
		{ 5, "Zero Speed|de|Stillstand|es|Veloc. Nula" },
		{ 6, "Is > Ix   |de|Is > Ix|es|Is > Ix   " },
		{ 7, "Is < Ix   |de|Is < Ix|es|Is < Ix   " },
		{ 8, "Torque > Tx |de|Moment > Mx|es|Torque > Tx " },
		{ 9, "Torque < Tx |de|Moment < Mx|es|Torque < Tx " },
		{ 10, "Remote    |de|REM|es|Remoto    " },
		{ 11, "Run       |de|Ein|es|Run       " },
		{ 12, "Ready     |de|Bereit|es|Ready     " },
		{ 13, "No Fault  |de|Ohne Fehler|es|Sin Falla " },
		{ 14, "No F070    |de|Ohne F070|es|Sin F070   " },
		{ 15, "No F071    |de|Ohne F071|es|Sin F071  " },
		{ 16, "No F006/21/22|de|OhneF006/21/22|es|Sin F006/21/22" },
		{ 17, "No F051/54/57|de|OhneF051/54/57|es|Sin F051/54/57" },
		{ 18, "No F072    |de|Ohne F072|es|Sin F072   " },
		{ 19, "4-20mA OK|de|4-20mA OK|es|4-20mA OK" },
		{ 20, "P0695 Value|de|P0695 Wert|es|ContenidoP0695" },
		{ 21, "Forward   |de|Rechtslauf|es|Sent. Horario" },
		{ 22, "Proc. V. > PVx|de|ProzVar>Pr.Vx|es|V. Proc. > VPx" },
		{ 23, "Proc. V. < PVy|de|ProzVar<Pr.Vy|es|V. Proc. < VPy" },
		{ 24, "Ride-Through|de|Durchlauf  |es|Ride-Through" },
		{ 25, "Pre-Charge OK |de|Vorladen OK |es|Precarga OK" },
		{ 26, "Fault|de|Mit Fehler|es|Con Falla" },
		{ 27, "Time Enab > Hx|de|Betriebsstd>Hx|es|Horas Hab > Hx" },
		{ 28, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 29, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 30, "N>Nx/Nt>Nx|de|N>Nx / Nt>Nx|es|N>Nx/Nt>Nx" },
		{ 31, "F > Fx (1)   |de|F > Fx (1)   |es|F > Fx (1)   " },
		{ 32, "F > Fx (2)   |de|F > Fx (2)   |es|F > Fx (2)   " },
		{ 33, "STO|de|STO|es|STO" },
		{ 34, "No F160    |de|Ohne F160|es|Sin F160   " },
		{ 35, "No Alarm|de|Ohne Alarm|es|Sin Alarma" },
		{ 36, "No Fault/Alarm|de|OhneFehler/Ala|es|SinFalla/Alarm" }
		DEFAULT_VALUE 13;
	}
}

COMMAND READ_P0275
{
	SLOT 1;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0275 }
	}
}

WRITE_P0275 LIKE READ_P0275
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0275 }
		REPLY { }
	}
}

VARIABLE P0276
{
	LABEL "P0276 DO2 Function (RL2)|de|P0276 DO2 Funktion (RL2)|es|P0276 Funcin de DO2 (RL2)";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "N* > Nx   |de|N* > Nx|es|N* > Nx   " },
		{ 2, "N > Nx    |de|N > Nx|es|N > Nx    " },
		{ 3, "N < Ny    |de|N < Ny|es|N < Ny    " },
		{ 4, "N = N*    |de|N = N*|es|N = N*    " },
		{ 5, "Zero Speed|de|Stillstand|es|Veloc. Nula" },
		{ 6, "Is > Ix   |de|Is > Ix|es|Is > Ix   " },
		{ 7, "Is < Ix   |de|Is < Ix|es|Is < Ix   " },
		{ 8, "Torque > Tx |de|Moment > Mx|es|Torque > Tx " },
		{ 9, "Torque < Tx |de|Moment < Mx|es|Torque < Tx " },
		{ 10, "Remote    |de|REM|es|Remoto    " },
		{ 11, "Run       |de|Ein|es|Run       " },
		{ 12, "Ready     |de|Bereit|es|Ready     " },
		{ 13, "No Fault  |de|Ohne Fehler|es|Sin Falla " },
		{ 14, "No F070    |de|Ohne F070|es|Sin F070   " },
		{ 15, "No F071    |de|Ohne F071|es|Sin F071  " },
		{ 16, "No F006/21/22|de|OhneF006/21/22|es|Sin F006/21/22" },
		{ 17, "No F051/54/57|de|OhneF051/54/57|es|Sin F051/54/57" },
		{ 18, "No F072    |de|Ohne F072|es|Sin F072   " },
		{ 19, "4-20mA OK|de|4-20mA OK|es|4-20mA OK" },
		{ 20, "P0695 Value|de|P0695 Wert|es|ContenidoP0695" },
		{ 21, "Forward   |de|Rechtslauf|es|Sent. Horario" },
		{ 22, "Proc. V. > PVx|de|ProzVar>Pr.Vx|es|V. Proc. > VPx" },
		{ 23, "Proc. V. < PVy|de|ProzVar<Pr.Vy|es|V. Proc. < VPy" },
		{ 24, "Ride-Through|de|Durchlauf  |es|Ride-Through" },
		{ 25, "Pre-Charge OK |de|Vorladen OK |es|Precarga OK" },
		{ 26, "Fault|de|Mit Fehler|es|Con Falla" },
		{ 27, "Time Enab > Hx|de|Betriebsstd>Hx|es|Horas Hab > Hx" },
		{ 28, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 29, "Timer|de|Timer|es|Temporizador" },
		{ 30, "N>Nx/Nt>Nx|de|N>Nx / Nt>Nx|es|N>Nx/Nt>Nx" },
		{ 31, "F > Fx (1)   |de|F > Fx (1)   |es|F > Fx (1)   " },
		{ 32, "F > Fx (2)   |de|F > Fx (2)   |es|F > Fx (2)   " },
		{ 33, "STO|de|STO|es|STO" },
		{ 34, "No F160    |de|Ohne F160|es|Sin F160   " },
		{ 35, "No Alarm|de|Ohne Alarm|es|Sin Alarma" },
		{ 36, "No Fault/Alarm|de|OhneFehler/Ala|es|SinFalla/Alarm" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0276
{
	SLOT 1;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0276 }
	}
}

WRITE_P0276 LIKE READ_P0276
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0276 }
		REPLY { }
	}
}

VARIABLE P0277
{
	LABEL "P0277 DO3 Function (RL3)|de|P0277 DO3 Funktion (RL3)|es|P0277 Funcin de DO3 (RL3)";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "N* > Nx   |de|N* > Nx|es|N* > Nx   " },
		{ 2, "N > Nx    |de|N > Nx|es|N > Nx    " },
		{ 3, "N < Ny    |de|N < Ny|es|N < Ny    " },
		{ 4, "N = N*    |de|N = N*|es|N = N*    " },
		{ 5, "Zero Speed|de|Stillstand|es|Veloc. Nula" },
		{ 6, "Is > Ix   |de|Is > Ix|es|Is > Ix   " },
		{ 7, "Is < Ix   |de|Is < Ix|es|Is < Ix   " },
		{ 8, "Torque > Tx |de|Moment > Mx|es|Torque > Tx " },
		{ 9, "Torque < Tx |de|Moment < Mx|es|Torque < Tx " },
		{ 10, "Remote    |de|REM|es|Remoto    " },
		{ 11, "Run       |de|Ein|es|Run       " },
		{ 12, "Ready     |de|Bereit|es|Ready     " },
		{ 13, "No Fault  |de|Ohne Fehler|es|Sin Falla " },
		{ 14, "No F070    |de|Ohne F070|es|Sin F070   " },
		{ 15, "No F071    |de|Ohne F071|es|Sin F071  " },
		{ 16, "No F006/21/22|de|OhneF006/21/22|es|Sin F006/21/22" },
		{ 17, "No F051/54/57|de|OhneF051/54/57|es|Sin F051/54/57" },
		{ 18, "No F072    |de|Ohne F072|es|Sin F072   " },
		{ 19, "4-20mA OK|de|4-20mA OK|es|4-20mA OK" },
		{ 20, "P0695 Value|de|P0695 Wert|es|ContenidoP0695" },
		{ 21, "Forward   |de|Rechtslauf|es|Sent. Horario" },
		{ 22, "Proc. V. > PVx|de|ProzVar>Pr.Vx|es|V. Proc. > VPx" },
		{ 23, "Proc. V. < PVy|de|ProzVar<Pr.Vy|es|V. Proc. < VPy" },
		{ 24, "Ride-Through|de|Durchlauf  |es|Ride-Through" },
		{ 25, "Pre-Charge OK |de|Vorladen OK |es|Precarga OK" },
		{ 26, "Fault|de|Mit Fehler|es|Con Falla" },
		{ 27, "Time Enab > Hx|de|Betriebsstd>Hx|es|Horas Hab > Hx" },
		{ 28, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 29, "Timer|de|Timer|es|Temporizador" },
		{ 30, "N>Nx/Nt>Nx|de|N>Nx / Nt>Nx|es|N>Nx/Nt>Nx" },
		{ 31, "F > Fx (1)   |de|F > Fx (1)   |es|F > Fx (1)   " },
		{ 32, "F > Fx (2)   |de|F > Fx (2)   |es|F > Fx (2)   " },
		{ 33, "STO|de|STO|es|STO" },
		{ 34, "No F160    |de|Ohne F160|es|Sin F160   " },
		{ 35, "No Alarm|de|Ohne Alarm|es|Sin Alarma" },
		{ 36, "No Fault/Alarm|de|OhneFehler/Ala|es|SinFalla/Alarm" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0277
{
	SLOT 1;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0277 }
	}
}

WRITE_P0277 LIKE READ_P0277
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0277 }
		REPLY { }
	}
}

VARIABLE P0278
{
	LABEL "P0278 DO4 Function    |de|P0278 DO4 Funktion|es|P0278 Funcin de DO4";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "N* > Nx   |de|N* > Nx|es|N* > Nx   " },
		{ 2, "N > Nx    |de|N > Nx|es|N > Nx    " },
		{ 3, "N < Ny    |de|N < Ny|es|N < Ny    " },
		{ 4, "N = N*    |de|N = N*|es|N = N*    " },
		{ 5, "Zero Speed|de|Stillstand|es|Veloc. Nula" },
		{ 6, "Is > Ix   |de|Is > Ix|es|Is > Ix   " },
		{ 7, "Is < Ix   |de|Is < Ix|es|Is < Ix   " },
		{ 8, "Torque > Tx |de|Moment > Mx|es|Torque > Tx " },
		{ 9, "Torque < Tx |de|Moment < Mx|es|Torque < Tx " },
		{ 10, "Remote    |de|REM|es|Remoto    " },
		{ 11, "Run       |de|Ein|es|Run       " },
		{ 12, "Ready     |de|Bereit|es|Ready     " },
		{ 13, "No Fault  |de|Ohne Fehler|es|Sin Falla " },
		{ 14, "No F070    |de|Ohne F070|es|Sin F070   " },
		{ 15, "No F071    |de|Ohne F071|es|Sin F071  " },
		{ 16, "No F006/21/22|de|OhneF006/21/22|es|Sin F006/21/22" },
		{ 17, "No F051/54/57|de|OhneF051/54/57|es|Sin F051/54/57" },
		{ 18, "No F072    |de|Ohne F072|es|Sin F072   " },
		{ 19, "4-20mA OK|de|4-20mA OK|es|4-20mA OK" },
		{ 20, "P0695 Value|de|P0695 Wert|es|ContenidoP0695" },
		{ 21, "Forward   |de|Rechtslauf|es|Sent. Horario" },
		{ 22, "Proc. V. > PVx|de|ProzVar>Pr.Vx|es|V. Proc. > VPx" },
		{ 23, "Proc. V. < PVy|de|ProzVar<Pr.Vy|es|V. Proc. < VPy" },
		{ 24, "Ride-Through|de|Durchlauf  |es|Ride-Through" },
		{ 25, "Pre-Charge OK |de|Vorladen OK |es|Precarga OK" },
		{ 26, "Fault|de|Mit Fehler|es|Con Falla" },
		{ 27, "Time Enab > Hx|de|Betriebsstd>Hx|es|Horas Hab > Hx" },
		{ 28, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 29, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 30, "N>Nx/Nt>Nx|de|N>Nx / Nt>Nx|es|N>Nx/Nt>Nx" },
		{ 31, "F > Fx (1)   |de|F > Fx (1)   |es|F > Fx (1)   " },
		{ 32, "F > Fx (2)   |de|F > Fx (2)   |es|F > Fx (2)   " },
		{ 33, "STO|de|STO|es|STO" },
		{ 34, "No F160    |de|Ohne F160|es|Sin F160   " },
		{ 35, "No Alarm|de|Ohne Alarm|es|Sin Alarma" },
		{ 36, "No Fault/Alarm|de|OhneFehler/Ala|es|SinFalla/Alarm" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0278
{
	SLOT 1;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0278 }
	}
}

WRITE_P0278 LIKE READ_P0278
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0278 }
		REPLY { }
	}
}

VARIABLE P0279
{
	LABEL "P0279 DO5 Function    |de|P0279 DO5 Funktion|es|P0279 Funcin de DO5  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "N* > Nx   |de|N* > Nx|es|N* > Nx   " },
		{ 2, "N > Nx    |de|N > Nx|es|N > Nx    " },
		{ 3, "N < Ny    |de|N < Ny|es|N < Ny    " },
		{ 4, "N = N*    |de|N = N*|es|N = N*    " },
		{ 5, "Zero Speed|de|Stillstand|es|Veloc. Nula" },
		{ 6, "Is > Ix   |de|Is > Ix|es|Is > Ix   " },
		{ 7, "Is < Ix   |de|Is < Ix|es|Is < Ix   " },
		{ 8, "Torque > Tx |de|Moment > Mx|es|Torque > Tx " },
		{ 9, "Torque < Tx |de|Moment < Mx|es|Torque < Tx " },
		{ 10, "Remote    |de|REM|es|Remoto    " },
		{ 11, "Run       |de|Ein|es|Run       " },
		{ 12, "Ready     |de|Bereit|es|Ready     " },
		{ 13, "No Fault  |de|Ohne Fehler|es|Sin Falla " },
		{ 14, "No F070    |de|Ohne F070|es|Sin F070   " },
		{ 15, "No F071    |de|Ohne F071|es|Sin F071  " },
		{ 16, "No F006/21/22|de|OhneF006/21/22|es|Sin F006/21/22" },
		{ 17, "No F051/54/57|de|OhneF051/54/57|es|Sin F051/54/57" },
		{ 18, "No F072    |de|Ohne F072|es|Sin F072   " },
		{ 19, "4-20mA OK|de|4-20mA OK|es|4-20mA OK" },
		{ 20, "P0695 Value|de|P0695 Wert|es|ContenidoP0695" },
		{ 21, "Forward   |de|Rechtslauf|es|Sent. Horario" },
		{ 22, "Proc. V. > PVx|de|ProzVar>Pr.Vx|es|V. Proc. > VPx" },
		{ 23, "Proc. V. < PVy|de|ProzVar<Pr.Vy|es|V. Proc. < VPy" },
		{ 24, "Ride-Through|de|Durchlauf  |es|Ride-Through" },
		{ 25, "Pre-Charge OK |de|Vorladen OK |es|Precarga OK" },
		{ 26, "Fault|de|Mit Fehler|es|Con Falla" },
		{ 27, "Time Enab > Hx|de|Betriebsstd>Hx|es|Horas Hab > Hx" },
		{ 28, "SoftPLC|de|SoftPLC|es|SoftPLC" },
		{ 29, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 30, "N>Nx/Nt>Nx|de|N>Nx / Nt>Nx|es|N>Nx/Nt>Nx" },
		{ 31, "F > Fx (1)   |de|F > Fx (1)   |es|F > Fx (1)   " },
		{ 32, "F > Fx (2)   |de|F > Fx (2)   |es|F > Fx (2)   " },
		{ 33, "STO|de|STO|es|STO" },
		{ 34, "No F160    |de|Ohne F160|es|Sin F160   " },
		{ 35, "No Alarm|de|Ohne Alarm|es|Sin Alarma" },
		{ 36, "No Fault/Alarm|de|OhneFehler/Ala|es|SinFalla/Alarm" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0279
{
	SLOT 1;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0279 }
	}
}

WRITE_P0279 LIKE READ_P0279
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0279 }
		REPLY { }
	}
}

VARIABLE P0281
{
	LABEL "P0281 Fx Frequency |de|P0281 Frequenz Fx|es|P0281 Frecuencia Fx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "Hz";
}

COMMAND READ_P0281
{
	SLOT 1;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0281 }
	}
}

WRITE_P0281 LIKE READ_P0281
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0281 }
		REPLY { }
	}
}

VARIABLE P0282
{
	LABEL "P0282 Fx Hysteresis|de|P0282 Fx Hysterese|es|P0282 Histresis Fx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "Hz";
}

COMMAND READ_P0282
{
	SLOT 1;
	INDEX 26;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0282 }
	}
}

WRITE_P0282 LIKE READ_P0282
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0282 }
		REPLY { }
	}
}

VARIABLE P0283
{
	LABEL "P0283 DO2 ON Time|de|P0283 DO2 Ein Zeit|es|P0283 Tiempo DO2 ON";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0283
{
	SLOT 1;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0283 }
	}
}

WRITE_P0283 LIKE READ_P0283
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0283 }
		REPLY { }
	}
}

VARIABLE P0284
{
	LABEL "P0284 DO2 OFF Time|de|P0284 DO2 Aus Zeit|es|P0284 Tiempo DO2 OFF";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0284
{
	SLOT 1;
	INDEX 28;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0284 }
	}
}

WRITE_P0284 LIKE READ_P0284
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0284 }
		REPLY { }
	}
}

VARIABLE P0285
{
	LABEL "P0285 DO3 ON Time|de|P0285 DO3 Ein Zeit|es|P0285 Tiempo DO3 ON";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0285
{
	SLOT 1;
	INDEX 29;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0285 }
	}
}

WRITE_P0285 LIKE READ_P0285
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0285 }
		REPLY { }
	}
}

VARIABLE P0286
{
	LABEL "P0286 DO3 OFF Time|de|P0286 DO3 Aus Zeit|es|P0286 Tiempo DO3 OFF";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0286
{
	SLOT 1;
	INDEX 30;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0286 }
	}
}

WRITE_P0286 LIKE READ_P0286
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0286 }
		REPLY { }
	}
}

VARIABLE P0287
{
	LABEL "P0287 Nx/Ny Hysteresis|de|P0287 Nx / Ny Hysterese|es|P0287 Histresis Nx/Ny";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 18;
		MIN_VALUE 0;
		MAX_VALUE 900;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0287
{
	SLOT 1;
	INDEX 31;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0287 }
	}
}

WRITE_P0287 LIKE READ_P0287
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0287 }
		REPLY { }
	}
}

VARIABLE P0288
{
	LABEL "P0288 Nx Speed        |de|P0288 Drehzahl Nx|es|P0288 Velocidad Nx    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 120;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0288
{
	SLOT 1;
	INDEX 32;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0288 }
	}
}

WRITE_P0288 LIKE READ_P0288
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0288 }
		REPLY { }
	}
}

VARIABLE P0289
{
	LABEL "P0289 Ny Speed        |de|P0289 Drehzahl Ny|es|P0289 Velocidad Ny    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1800;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0289
{
	SLOT 1;
	INDEX 33;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0289 }
	}
}

WRITE_P0289 LIKE READ_P0289
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0289 }
		REPLY { }
	}
}

VARIABLE P0290
{
	LABEL "P0290 Ix Current      |de|P0290 Strom Ix|es|P0290 Corriente Ix    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0290
{
	SLOT 1;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0290 }
	}
}

WRITE_P0290 LIKE READ_P0290
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0290 }
		REPLY { }
	}
}

VARIABLE P0291
{
	LABEL "P0291 Zero Speed Zone |de|P0291 Stillstand|es|P0291 Velocidad Nula  ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 18;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0291
{
	SLOT 1;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0291 }
	}
}

WRITE_P0291 LIKE READ_P0291
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0291 }
		REPLY { }
	}
}

VARIABLE P0292
{
	LABEL "P0292 N = N* Band       |de|P0292 N = N* Bereich|es|P0292 Rango para N = N* ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 18;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0292
{
	SLOT 1;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0292 }
	}
}

WRITE_P0292 LIKE READ_P0292
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0292 }
		REPLY { }
	}
}

VARIABLE P0293
{
	LABEL "P0293 Tx Torque       |de|P0293 Moment Tx|es|P0293 Torque Tx       ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 100;
		MIN_VALUE 0;
		MAX_VALUE 200;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0293
{
	SLOT 1;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0293 }
	}
}

WRITE_P0293 LIKE READ_P0293
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0293 }
		REPLY { }
	}
}

VARIABLE P0294
{
	LABEL "P0294 Hx Time|de|P0294 Hx Stunden|es|P0294 Horas Hx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 4320;
		MIN_VALUE 0;
		MAX_VALUE 6553;
	}
	CONSTANT_UNIT "h";
}

COMMAND READ_P0294
{
	SLOT 1;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0294 }
	}
}

WRITE_P0294 LIKE READ_P0294
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0294 }
		REPLY { }
	}
}

VARIABLE P0295
{
	LABEL "P0295 ND/HD VFD Rated Curr.|de|P0295 FU Nennstrom ND/HD|es|P0295 Corr.Nomin.ND/HD Conv";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "3.6A / 3.6A|de|3.6A / 3.6A|es|3.6A / 3.6A" },
		{ 1, "5A / 5A|de|5A / 5A|es|5A / 5A" },
		{ 2, "6A / 5A|de|6A / 5A|es|6A / 5A" },
		{ 3, "7A / 5.5A|de|7A / 5.5A|es|7A / 5.5A" },
		{ 4, "7A / 7A|de|7A / 7A|es|7A / 7A" },
		{ 5, "10A / 8A|de|10A / 8A|es|10A / 8A" },
		{ 6, "10A / 10A|de|10A / 10A|es|10A / 10A" },
		{ 7, "13A / 11A|de|13A / 11A|es|13A / 11A" },
		{ 8, "13.5A / 11A|de|13.5A / 11A|es|13.5A / 11A" },
		{ 9, "16A / 13A|de|16A / 13A|es|16A / 13A" },
		{ 10, "17A / 13.5A|de|17A / 13.5A|es|17A / 13.5A" },
		{ 11, "24A / 19A|de|24A / 19A|es|24A / 19A" },
		{ 12, "24A / 20A|de|24A / 20A|es|24A / 20A" },
		{ 13, "28A / 24A|de|28A / 24A|es|28A / 24A" },
		{ 14, "31A / 25A|de|31A / 25A|es|31A / 25A" },
		{ 15, "33.5A / 28A|de|33.5A / 28A|es|33.5A / 28A" },
		{ 16, "38A / 33A|de|38A / 33A|es|38A / 33A" },
		{ 17, "45A / 36A|de|45A / 36A|es|45A / 36A" },
		{ 18, "45A / 38A|de|45A / 38A|es|45A / 38A" },
		{ 19, "54A / 45A|de|54A / 45A|es|54A / 45A" },
		{ 20, "58.5A / 47A|de|58.5A / 47A|es|58.5A / 47A" },
		{ 21, "70A / 56A|de|70A / 56A|es|70A / 56A" },
		{ 22, "70.5A / 61A|de|70.5A / 61A|es|70.5A / 61A" },
		{ 23, "86A / 70A|de|86A / 70A|es|86A / 70A" },
		{ 24, "88A / 73A|de|88A / 73A|es|88A / 73A" },
		{ 25, "105A / 86A|de|105A / 86A|es|105A / 86A" },
		{ 26, "427A / 427A|de|427A / 427A|es|427A / 427A" },
		{ 27, "470A / 470A|de|470A / 470A|es|470A / 470A" },
		{ 28, "811A / 811A|de|811A / 811A|es|811A / 811A" },
		{ 29, "893A / 893A|de|893A / 893A|es|893A / 893A" },
		{ 30, "1216A / 1216A|de|1216A / 1216A|es|1216A / 1216A" },
		{ 31, "1339A / 1339A|de|1339A / 1339A|es|1339A / 1339A" },
		{ 32, "1622A / 1622A|de|1622A / 1622A|es|1622A / 1622A" },
		{ 33, "1786A / 1786A|de|1786A / 1786A|es|1786A / 1786A" },
		{ 34, "2028A / 2028A|de|2028A / 2028A|es|2028A / 2028A" },
		{ 35, "2232A / 2232A|de|2232A / 2232A|es|2232A / 2232A" },
		{ 36, "2A / 2A|de|2A / 2A|es|2A / 2A" }
		DEFAULT_VALUE 2;
	}
	HANDLING READ;
}

COMMAND READ_P0295
{
	SLOT 1;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0295 }
	}
}

VARIABLE P0296
{
	LABEL "P0296 Line Rated Voltage |de|P0296 FU Nennspannung|es|P0296 Tensin Nominal Red";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "200 - 240 V |de|200 - 240 V |es|200 - 240 V " },
		{ 1, "380 V|de|380 V|es|380 V" },
		{ 2, "400 - 415 V |de|400 - 415 V |es|400 - 415 V " },
		{ 3, "440 - 460 V|de|440 - 460 V|es|440 - 460 V" },
		{ 4, "480 V|de|480 V|es|480 V" },
		{ 5, "500 - 525 V |de|500 - 525 V |es|500 - 525 V " },
		{ 6, "550 - 575 V |de|550 - 575 V |es|550 - 575 V " },
		{ 7, "600 V |de|600 V |es|600 V " },
		{ 8, "660 - 690 V |de|660 - 690 V |es|660 - 690 V " }
		DEFAULT_VALUE 3;
	}
}

COMMAND READ_P0296
{
	SLOT 1;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0296 }
	}
}

WRITE_P0296 LIKE READ_P0296
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0296 }
		REPLY { }
	}
}

VARIABLE P0297
{
	LABEL "P0297 Switching Frequency|de|P0297 Taktfrequenz|es|P0297 Frec. Conmutacin";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, " 1.25 kHz |de| 1.25 kHz |es| 1.25 kHz " },
		{ 1, " 2.5 kHz  |de| 2.5 kHz  |es| 2.5 kHz  " },
		{ 2, " 5.0 kHz  |de| 5.0 kHz  |es| 5.0 kHz  " },
		{ 3, "10.0 kHz  |de|10.0 kHz  |es|10.0 kHz  " }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0297
{
	SLOT 1;
	INDEX 41;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0297 }
	}
}

WRITE_P0297 LIKE READ_P0297
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0297 }
		REPLY { }
	}
}

VARIABLE P0298
{
	LABEL "P0298 Application|de|P0298 Anwendung|es|P0298 Aplicacin";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Normal Duty|de|Normal Duty|es|Normal Duty" },
		{ 1, "Heavy Duty|de|Heavy Duty|es|Heavy Duty" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0298
{
	SLOT 1;
	INDEX 42;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0298 }
	}
}

WRITE_P0298 LIKE READ_P0298
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0298 }
		REPLY { }
	}
}

VARIABLE P0299
{
	LABEL "P0299 DC-Braking Start Time|de|P0299 Bremszeit Start|es|P0299 Tiempo Fren. Partida ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0299
{
	SLOT 1;
	INDEX 43;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0299 }
	}
}

WRITE_P0299 LIKE READ_P0299
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0299 }
		REPLY { }
	}
}

VARIABLE P0300
{
	LABEL "P0300 DC-Braking Stop Time|de|P0300 Bremszeit Stop|es|P0300 Tiempo Fren. Parada ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0300
{
	SLOT 1;
	INDEX 44;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0300 }
	}
}

WRITE_P0300 LIKE READ_P0300
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0300 }
		REPLY { }
	}
}

VARIABLE P0301
{
	LABEL "P0301 DC-Braking Speed  |de|P0301 Bremsdrehzahl|es|P0301 Velocidad de Inicio";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 30;
		MIN_VALUE 0;
		MAX_VALUE 450;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0301
{
	SLOT 1;
	INDEX 45;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0301 }
	}
}

WRITE_P0301 LIKE READ_P0301
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0301 }
		REPLY { }
	}
}

VARIABLE P0302
{
	LABEL "P0302 DC-Braking Voltage|de|P0302 Bremsspannung|es|P0302 Tensin CC Frenado";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0302
{
	SLOT 1;
	INDEX 46;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0302 }
	}
}

WRITE_P0302 LIKE READ_P0302
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0302 }
		REPLY { }
	}
}

VARIABLE P0303
{
	LABEL "P0303 Skip Speed 1    |de|P0303 1.berspr.Drehzahl|es|P0303 Velocidad Rechazada 1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 600;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0303
{
	SLOT 1;
	INDEX 47;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0303 }
	}
}

WRITE_P0303 LIKE READ_P0303
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0303 }
		REPLY { }
	}
}

VARIABLE P0304
{
	LABEL "P0304 Skip Speed 2    |de|P0304 2.berspr.Drehzahl|es|P0304 Velocidad Rechazada 2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 900;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0304
{
	SLOT 1;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0304 }
	}
}

WRITE_P0304 LIKE READ_P0304
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0304 }
		REPLY { }
	}
}

VARIABLE P0305
{
	LABEL "P0305 Skip Speed 3    |de|P0305 3.berspr.Drehzahl|es|P0305 Velocidad Rechazada 3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1200;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0305
{
	SLOT 1;
	INDEX 49;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0305 }
	}
}

WRITE_P0305 LIKE READ_P0305
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0305 }
		REPLY { }
	}
}

VARIABLE P0306
{
	LABEL "P0306 Skip Band       |de|P0306 bersprung Bereich|es|P0306 Rango Rechazado ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 750;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0306
{
	SLOT 1;
	INDEX 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0306 }
	}
}

WRITE_P0306 LIKE READ_P0306
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0306 }
		REPLY { }
	}
}

VARIABLE P0308
{
	LABEL "P0308 Serial Address     |de|P0308 Serielle Adresse|es|P0308 Direccin Serie";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1;
		MIN_VALUE 1;
		MAX_VALUE 247;
	}
}

COMMAND READ_P0308
{
	SLOT 1;
	INDEX 52;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0308 }
	}
}

WRITE_P0308 LIKE READ_P0308
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0308 }
		REPLY { }
	}
}

VARIABLE P0310
{
	LABEL "P0310 Serial Baud Rate|de|P0310 Seriella Baud Rate|es|P0310 Tasa Comunic. Serie";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "9600 bits/s|de|9600 bits/s|es|9600 bits/s" },
		{ 1, "19200 bits/s|de|19200 bits/s|es|19200 bits/s" },
		{ 2, "38400 bits/s|de|38400 bits/s|es|38400 bits/s" },
		{ 3, "57600 bits/s|de|57600 bits/s|es|57600 bits/s" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0310
{
	SLOT 1;
	INDEX 54;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0310 }
	}
}

WRITE_P0310 LIKE READ_P0310
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0310 }
		REPLY { }
	}
}

VARIABLE P0311
{
	LABEL "P0311 Serial Bytes Config.|de|P0311 Serielle Byte Konfig.|es|P0311 Config. Bytes Serie";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "8 bits, no, 1|de|8 bits/ohne/1|es|8 bits, sin, 1" },
		{ 1, "8 bits, even,1|de|8 bits/gerad/1|es|8 bits, par, 1" },
		{ 2, "8 bits, odd, 1|de|8 bits/ung./1|es|8 bits, imp, 1" },
		{ 3, "8 bits, no, 2|de|8 bits/ohne/2|es|8 bits, sin, 2" },
		{ 4, "8 bits, even,2|de|8 bits/gerad/2|es|8 bits, par, 2" },
		{ 5, "8 bits, odd, 2|de|8 bits/ung./2|es|8 bits, imp, 2" }
		DEFAULT_VALUE 3;
	}
}

COMMAND READ_P0311
{
	SLOT 1;
	INDEX 55;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0311 }
	}
}

WRITE_P0311 LIKE READ_P0311
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0311 }
		REPLY { }
	}
}

VARIABLE P0312
{
	LABEL "P0312 Serial Protocol|de|P0312 Serielles Protokoll|es|P0312 Protocolo Serie";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 1, "TP|de|TP|es|TP" },
		{ 2, "Modbus RTU|de|Modbus RTU|es|Modbus RTU" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0312
{
	SLOT 1;
	INDEX 56;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0312 }
	}
}

WRITE_P0312 LIKE READ_P0312
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0312 }
		REPLY { }
	}
}

VARIABLE P0313
{
	LABEL "P0313 Comm. Error Action|de|P0313 Kom. Fehler Aktion|es|P0313 Accin p/Erro Comunic";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactivo" },
		{ 1, "Ramp Stop|de|Rampenstop|es|Para por Rampa" },
		{ 2, "General Disab.|de|Gen. Abschalt.|es|Deshab.General" },
		{ 3, "Go to LOC|de|Gehe zu LOC|es|Ir p/ LOC" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0313
{
	SLOT 1;
	INDEX 57;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0313 }
	}
}

WRITE_P0313 LIKE READ_P0313
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0313 }
		REPLY { }
	}
}

VARIABLE P0314
{
	LABEL "P0314 Serial Watchdog|de|P0314 Serieller-Watchdog|es|P0314 Watchdog Serie";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0314
{
	SLOT 1;
	INDEX 58;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0314 }
	}
}

WRITE_P0314 LIKE READ_P0314
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0314 }
		REPLY { }
	}
}

VARIABLE P0316
{
	LABEL "P0316 Serial Interf. Status|de|P0316 Schnittstellenstatus|es|P0316 Estado Interf. Serie";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactivo" },
		{ 1, "On        |de|Ein|es|Activo" },
		{ 2, "Watchdog Error|de|Watchdog Feh.|es|Error Watchdog" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0316
{
	SLOT 1;
	INDEX 60;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0316 }
	}
}

VARIABLE P0320
{
	LABEL "P0320 FlyStart/Ride-Through|de|P0320 FliegStart/Durchlauf|es|P0320 FlyStart/Ride-Through";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactivas  " },
		{ 1, "Flying Start |de|Fliegend Start|es|Flying Start " },
		{ 2, "FS / RT   |de|FS / DL|es|FS / RT    " },
		{ 3, "Ride-Through |de|Durchlauf  |es|Ride-Through " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0320
{
	SLOT 1;
	INDEX 64;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0320 }
	}
}

WRITE_P0320 LIKE READ_P0320
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0320 }
		REPLY { }
	}
}

VARIABLE P0321
{
	LABEL "P0321 DC Link Power Loss|de|P0321 ZwKrSpg Abfallpegel|es|P0321 Ud Falta de Red";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0321
{
	SLOT 1;
	INDEX 65;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0321 }
	}
}

WRITE_P0321 LIKE READ_P0321
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0321 }
		REPLY { }
	}
}

VARIABLE P0322
{
	LABEL "P0322 DC Link Ride-Through|de|P0322 ZwKrSpg Durchlauf|es|P0322 Ud Ride-Through";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0322
{
	SLOT 1;
	INDEX 66;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0322 }
	}
}

WRITE_P0322 LIKE READ_P0322
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0322 }
		REPLY { }
	}
}

VARIABLE P0323
{
	LABEL "P0323 DC Link Power Back|de|P0323 ZwKrSpg Rckkehrp.|es|P0323 Ud Retorno Red";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0323
{
	SLOT 1;
	INDEX 67;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0323 }
	}
}

WRITE_P0323 LIKE READ_P0323
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0323 }
		REPLY { }
	}
}

VARIABLE P0325
{
	LABEL "P0325 Ride-Through P Gain|de|P0325 Durchl. P-Verstrkung|es|P0325 Ganancia Prop. RT";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
}

COMMAND READ_P0325
{
	SLOT 1;
	INDEX 69;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0325 }
	}
}

WRITE_P0325 LIKE READ_P0325
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0325 }
		REPLY { }
	}
}

VARIABLE P0326
{
	LABEL "P0326 Ride-Through I Gain|de|P0326 Durchl. I-Verstrkung|es|P0326 Ganancia Integr. RT";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0326
{
	SLOT 1;
	INDEX 70;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0326 }
	}
}

WRITE_P0326 LIKE READ_P0326
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0326 }
		REPLY { }
	}
}

VARIABLE P0327
{
	LABEL "P0327 F.S. Current Ramp I/f|de|P0327 FS Stromrampe I/f|es|P0327 Rampa Corr. I/f F.S.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0327
{
	SLOT 1;
	INDEX 71;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0327 }
	}
}

WRITE_P0327 LIKE READ_P0327
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0327 }
		REPLY { }
	}
}

VARIABLE P0328
{
	LABEL "P0328 Flying Start Filter|de|P0328 FS Filter|es|P0328 Filtro Flying Start";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0328
{
	SLOT 1;
	INDEX 72;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0328 }
	}
}

WRITE_P0328 LIKE READ_P0328
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0328 }
		REPLY { }
	}
}

VARIABLE P0329
{
	LABEL "P0329 Frequency Ramp F.S.|de|P0329 FS Frequenzrampe I/f|es|P0329 Rampa Frec. I/f F.S.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
}

COMMAND READ_P0329
{
	SLOT 1;
	INDEX 73;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0329 }
	}
}

WRITE_P0329 LIKE READ_P0329
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0329 }
		REPLY { }
	}
}

VARIABLE P0331
{
	LABEL "P0331 Voltage Ramp|de|P0331 Spannungsrampe|es|P0331 Rampa de Tensin";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0331
{
	SLOT 1;
	INDEX 75;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0331 }
	}
}

WRITE_P0331 LIKE READ_P0331
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0331 }
		REPLY { }
	}
}

VARIABLE P0332
{
	LABEL "P0332 Dead Time|de|P0332 Totzeit|es|P0332 Tiempo Muerto";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0332
{
	SLOT 1;
	INDEX 76;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0332 }
	}
}

WRITE_P0332 LIKE READ_P0332
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0332 }
		REPLY { }
	}
}

VARIABLE P0340
{
	LABEL "P0340 Auto-Reset Time |de|P0340 Autoreset Zeit|es|P0340 Tiempo AutoReset";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 255;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0340
{
	SLOT 1;
	INDEX 84;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0340 }
	}
}

WRITE_P0340 LIKE READ_P0340
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0340 }
		REPLY { }
	}
}

VARIABLE P0342
{
	LABEL "P0342 Motor Unbal.Curr.Conf|de|P0342 Unsym.Motorstrom Konf|es|P0342 Conf.Corr.Deseq.Motor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0342
{
	SLOT 1;
	INDEX 86;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0342 }
	}
}

WRITE_P0342 LIKE READ_P0342
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0342 }
		REPLY { }
	}
}

VARIABLE P0343
{
	LABEL "P0343 Ground Fault Config.|de|P0343 Erdfehler Konfig.|es|P0343 Config.Falla a Tierra";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0343
{
	SLOT 1;
	INDEX 87;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0343 }
	}
}

WRITE_P0343 LIKE READ_P0343
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0343 }
		REPLY { }
	}
}

VARIABLE P0344
{
	LABEL "P0344 Current Lim. Conf.|de|P0344 Strombegrenzung Kon.|es|P0344 Conf. Lim. Corriente";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Hold - FL ON|de|Hold - SB ON|es|Hold - LR ON" },
		{ 1, "Decel. - FL ON|de|Brems. - SB ON|es|Desac. - LR ON" },
		{ 2, "Hold - FL OFF|de|Hold - SB OFF|es|Hold - LR OFF" },
		{ 3, "Decel.- FL OFF|de|Brems.- SB OFF|es|Desac.- LR OFF" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0344
{
	SLOT 1;
	INDEX 88;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0344 }
	}
}

WRITE_P0344 LIKE READ_P0344
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0344 }
		REPLY { }
	}
}

VARIABLE P0348
{
	LABEL "P0348 Motor Overload Conf.|de|P0348 Motorberlastkonfig.|es|P0348 Conf.Sobrecarga Motor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactiva" },
		{ 1, "Fault/Alarm|de|Fehler / Alarm|es|Falla/Alarma" },
		{ 2, "Fault|de|Fehler|es|Falla" },
		{ 3, "Alarm|de|Alarm|es|Alarma" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0348
{
	SLOT 1;
	INDEX 92;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0348 }
	}
}

WRITE_P0348 LIKE READ_P0348
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0348 }
		REPLY { }
	}
}

VARIABLE P0349
{
	LABEL "P0349 Ixt Alarm Level|de|P0349 Niveau I x t Alarm|es|P0349 Nivel para Alarma Ixt";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 85;
		MIN_VALUE 70;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0349
{
	SLOT 1;
	INDEX 93;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0349 }
	}
}

WRITE_P0349 LIKE READ_P0349
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0349 }
		REPLY { }
	}
}

VARIABLE P0350
{
	LABEL "P0350 IGBTs Overload Conf.|de|P0350 IGBT berlast Konfig.|es|P0350 Conf.Sobrecarga IGBTs";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "F,   w/ SF rd.|de|F. mit red. SF|es|F   c/red. Fs" },
		{ 1, "F/A, w/ SF rd.|de|F/A m. red. SF|es|F/A c/red. Fs" },
		{ 2, "F,   no SF rd.|de|F ohne red. SF|es|F   s/red. Fs" },
		{ 3, "F/A, no SF rd.|de|F/A o. red. SF|es|F/A s/red. Fs" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0350
{
	SLOT 1;
	INDEX 94;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0350 }
	}
}

WRITE_P0350 LIKE READ_P0350
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0350 }
		REPLY { }
	}
}

VARIABLE P0351
{
	LABEL "P0351 Motor Overtemp. Conf.|de|P0351 Motorbertemperatur|es|P0351 Conf. Sobretemp.Motor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactiva" },
		{ 1, "Fault/Alarm|de|Fehler / Alarm|es|Falla/Alarma" },
		{ 2, "Fault|de|Fehler|es|Falla" },
		{ 3, "Alarm|de|Alarm|es|Alarma" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0351
{
	SLOT 1;
	INDEX 95;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0351 }
	}
}

WRITE_P0351 LIKE READ_P0351
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0351 }
		REPLY { }
	}
}

VARIABLE P0352
{
	LABEL "P0352 Fan Control Config.|de|P0352 Lfter Konfiguration|es|P0352 Config. Ventiladores";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "HS-OFF,Int-OFF|de|K-AUS, In-AUS|es|VD-OFF,VI-OFF" },
		{ 1, "HS-ON,Int-ON|de|K-EIN, In-EIN|es|VD-ON,VI-ON" },
		{ 2, "HS-CT,Int-CT|de|K-Ges, In-Ges|es|VD-CT,VI-CT" },
		{ 3, "HS-CT,Int-OFF|de|K-Ges, In-AUS|es|VD-CT,VI-OFF" },
		{ 4, "HS-CT,Int-ON|de|K-Ges, In-EIN|es|VD-CT,VI-ON" },
		{ 5, "HS-ON,Int-OFF|de|K-EIN, In-AUS|es|VD-ON,VI-OFF" },
		{ 6, "HS-ON,Int-CT|de|K-EIN, In-Ges|es|VD-ON,VI-CT" },
		{ 7, "HS-OFF,Int-ON|de|K-AUS, In-EIN|es|VD-OFF,VI-ON" },
		{ 8, "HS-OFF,Int-CT|de|K-AUS, In-Ges|es|VD-OFF,VI-CT" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0352
{
	SLOT 1;
	INDEX 96;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0352 }
	}
}

WRITE_P0352 LIKE READ_P0352
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0352 }
		REPLY { }
	}
}

VARIABLE P0353
{
	LABEL "P0353 IGBTs/Air Overtmp.Cfg|de|P0353 bertemp. IGBTs/Luft|es|P0353 Cfg.Sobrtmp.IGBT/Aire";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "HS-F/A,Air-F/A|de|KK-F/A, Lu-F/A|es|D-F/A,Aire-F/A" },
		{ 1, "HS-F/A, Air-F|de|KK-F/A, Luft-F|es|D-F/A, Aire-F" },
		{ 2, "HS-F, Air-F/A|de|KK-F, Luft-F/A|es|D-F, Aire-F/A" },
		{ 3, "HS-F, Air-F|de|KK-F, Luft-F|es|D-F, Aire-F" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0353
{
	SLOT 1;
	INDEX 97;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0353 }
	}
}

WRITE_P0353 LIKE READ_P0353
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0353 }
		REPLY { }
	}
}

VARIABLE P0354
{
	LABEL "P0354 Fan Speed Config.|de|P0354 Lftergeschw. Konfig.|es|P0354 Conf. Veloc. Ventil.";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactiva" },
		{ 1, "Fault|de|Fehler|es|Falla" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0354
{
	SLOT 1;
	INDEX 98;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0354 }
	}
}

WRITE_P0354 LIKE READ_P0354
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0354 }
		REPLY { }
	}
}

VARIABLE P0356
{
	LABEL "P0356 Dead Time Compens.|de|P0356 Totzeit Kompensation|es|P0356 Compens.Tiempo Muerto";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0356
{
	SLOT 1;
	INDEX 100;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0356 }
	}
}

WRITE_P0356 LIKE READ_P0356
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0356 }
		REPLY { }
	}
}

VARIABLE P0357
{
	LABEL "P0357 Line Phase Loss Time|de|P0357 Zeit Phasenverlust|es|P0357 Tiempo Ausencia Fase";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 3;
		MIN_VALUE 0;
		MAX_VALUE 60;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0357
{
	SLOT 1;
	INDEX 101;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0357 }
	}
}

WRITE_P0357 LIKE READ_P0357
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0357 }
		REPLY { }
	}
}

VARIABLE P0359
{
	LABEL "P0359 Motor Current Stabil.|de|P0359 Motorstrom Stabil.|es|P0359 Estab.Corriente Motor";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off|de|Aus|es|Inactiva" },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0359
{
	SLOT 1;
	INDEX 103;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0359 }
	}
}

WRITE_P0359 LIKE READ_P0359
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0359 }
		REPLY { }
	}
}

VARIABLE P0372
{
	LABEL "P0372 DC-Braking Curr Sless|de|P0372 Bremsstrom Sensorless|es|P0372 Corr. Fren. CC Sless";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0372
{
	SLOT 1;
	INDEX 116;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0372 }
	}
}

WRITE_P0372 LIKE READ_P0372
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0372 }
		REPLY { }
	}
}

VARIABLE P0397
{
	LABEL "P0397 Slip Compens. Regen.|de|P0397 Schlupfkompensation|es|P0397 Compens.Desliz.Regen.";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactiva  " },
		{ 1, "On        |de|Ein|es|Activa    " }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0397
{
	SLOT 1;
	INDEX 141;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0397 }
	}
}

WRITE_P0397 LIKE READ_P0397
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0397 }
		REPLY { }
	}
}

VARIABLE P0398
{
	LABEL "P0398 Motor Service Factor|de|P0398 Motor berlastfaktor|es|P0398 Factor Servicio Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0398
{
	SLOT 1;
	INDEX 142;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0398 }
	}
}

WRITE_P0398 LIKE READ_P0398
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0398 }
		REPLY { }
	}
}

VARIABLE P0399
{
	LABEL "P0399 Motor Rated Eff.|de|P0399 Motor Effizienz|es|P0399 Rendimiento Nom.Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0399
{
	SLOT 1;
	INDEX 143;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0399 }
	}
}

WRITE_P0399 LIKE READ_P0399
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0399 }
		REPLY { }
	}
}

VARIABLE P0400
{
	LABEL "P0400 Motor Rated Voltage|de|P0400 Motor Nennspannung|es|P0400 Tensin Nominal Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	CONSTANT_UNIT "V";
}

COMMAND READ_P0400
{
	SLOT 1;
	INDEX 144;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0400 }
	}
}

WRITE_P0400 LIKE READ_P0400
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0400 }
		REPLY { }
	}
}

VARIABLE P0401
{
	LABEL "P0401 Motor Rated Current|de|P0401 Motor Nennstrom|es|P0401 Corriente Nom. Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0401
{
	SLOT 1;
	INDEX 145;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0401 }
	}
}

WRITE_P0401 LIKE READ_P0401
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0401 }
		REPLY { }
	}
}

VARIABLE P0402
{
	LABEL "P0402 Motor Rated Speed |de|P0402 Motor Nenndrehzahl|es|P0402 Rotacin Nom. Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1750;
		MIN_VALUE 0;
		MAX_VALUE 18000;
	}
	CONSTANT_UNIT "rpm";
}

COMMAND READ_P0402
{
	SLOT 1;
	INDEX 146;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0402 }
	}
}

WRITE_P0402 LIKE READ_P0402
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0402 }
		REPLY { }
	}
}

VARIABLE P0403
{
	LABEL "P0403 Motor Rated Frequency|de|P0403 Motor Nennfrequenz|es|P0403 Frecuencia Nom. Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 60;
		MIN_VALUE 0;
		MAX_VALUE 300;
	}
	CONSTANT_UNIT "Hz";
}

COMMAND READ_P0403
{
	SLOT 1;
	INDEX 147;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0403 }
	}
}

WRITE_P0403 LIKE READ_P0403
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0403 }
		REPLY { }
	}
}

VARIABLE P0404
{
	LABEL "P0404 Motor Rated Power|de|P0404 Motor Nennleistung|es|P0404 Potencia Nom. Motor ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "0.33hp 0.25kW|de|  0.25 kW|es|  0.33 HP " },
		{ 1, "0.5hp 0.37kW|de|  0.37 kW|es|  0.50 HP" },
		{ 2, "0.75hp 0.55kW|de|  0.55 kW|es|  0.75 HP " },
		{ 3, "1hp 0.75kW|de|  0.75 kW|es|   1.0 HP  " },
		{ 4, "1.5hp 1.1kW|de|   1.1 kW|es|   1.5 HP " },
		{ 5, "2hp 1.5kW |de|   1.5 kW|es|   2.0 HP " },
		{ 6, "3hp 2.2kW|de|   2.2 kW|es|   3.0 HP " },
		{ 7, "4hp 3kW|de|   3.0 kW|es|   4.0 HP " },
		{ 8, "5hp 3.7kW|de|   3.7 kW|es|   5.0 HP " },
		{ 9, "5.5hp 4kW |de|   4.0 kW |es|   5.5 HP" },
		{ 10, "6hp 4.5kW|de|   4.5 kW|es|   6.0 HP " },
		{ 11, "7.5hp 5.5kW|de|   5.5 kW|es|   7.5 HP " },
		{ 12, "10hp 7.5kW|de|   7.5 kW|es|  10.0 HP " },
		{ 13, "12.5hp 9kW|de|   9.2 kW|es|  12.5 HP" },
		{ 14, "15hp 11kW|de|  11.0 kW|es|  15.0 HP " },
		{ 15, "20hp 15kW|de|  15.0 kW|es|  20.0 HP " },
		{ 16, "25hp 18.5kW|de|  18.5 kW|es|  25.0 HP " },
		{ 17, "30hp 22kW|de|  22.0 kW|es|  30.0 HP " },
		{ 18, "40hp 30kW|de|  30.0 kW|es|  40.0 HP " },
		{ 19, "50hp 37kW|de|  37.0 kW|es|  50.0 HP " },
		{ 20, "60hp 45kW|de|  45.0 kW|es|  60.0 HP " },
		{ 21, "75hp 55kW|de|  55.0 kW|es|  75.0 HP " },
		{ 22, "100hp 75kW|de|  75.0 kW|es| 100.0 HP " },
		{ 23, "125hp 90kW|de|  90.0 kW|es| 125.0 HP " },
		{ 24, "150hp 110kW|de| 110.0 kW|es| 150.0 HP " },
		{ 25, "175hp 130kW|de| 130.0 kW|es| 175.0 HP " },
		{ 26, "180hp 132kW |de|132.0 kW |es| 180.0 HP" },
		{ 27, "200hp 150kW|de| 150.0 kW|es| 200.0 HP " },
		{ 28, "220hp 160kW|de|160.0 kW |es| 220.0 HP " },
		{ 29, "250hp 185kW|de| 185.0 kW|es| 250.0 HP " },
		{ 30, "270hp 200kW|de| 200.0 kW|es| 270.0 HP " },
		{ 31, "300hp 220kW|de| 220.0 kW|es| 300.0 HP " },
		{ 32, "350hp 260kW|de| 260.0 kW|es| 350.0 HP " },
		{ 33, "380hp 280kW|de| 280.0 kW|es| 380.0 HP " },
		{ 34, "400hp 300kW|de| 300.0 kW|es| 400.0 HP " },
		{ 35, "430hp 315kW|de|315.0 kW |es| 430.0 HP" },
		{ 36, "440hp 330kW|de|330.0 kW |es| 440.0 HP" },
		{ 37, "450hp 335kW|de| 335.0 kW|es| 450.0 HP " },
		{ 38, "475hp 355kW|de|355.0 kW |es| 475.0 HP" },
		{ 39, "500hp 375kW|de| 375.0 kW|es| 500.0 HP " },
		{ 40, "540hp 400kW|de| 400.0 kW|es| 540.0 HP " },
		{ 41, "600hp 450kW|de| 450.0 kW|es| 600.0 HP " },
		{ 42, "620hp 460kW|de| 460.0 kW|es| 620.0 HP " },
		{ 43, "670hp 500kW|de|500.0 kW|es| 670.0 HP " },
		{ 44, "700hp 525kW|de| 525.0 kW|es| 700.0 HP " },
		{ 45, "760hp 570kW|de| 570.0 kW|es| 760.0 HP " },
		{ 46, "800hp 600kW|de| 600.0 kW|es| 800.0 HP " },
		{ 47, "850hp 630kW|de| 630.0 kW|es| 850.0 HP " },
		{ 48, "900hp 670kW|de| 670.0 kW|es| 900.0 HP " },
		{ 49, "1000hp 736kW|de|736.0 kW |es| 1000.0 HP " },
		{ 50, "1100hp 810kW|de|810.0 kW |es| 1100.0 HP " },
		{ 51, "1250hp 920kW|de|920.0 kW |es| 1250.0 HP " },
		{ 52, "1400hp 1030kW|de|1030.0 kW |es| 1400.0 HP " },
		{ 53, "1500hp 1110kW|de|1110.0 kW |es| 1500.0 HP " },
		{ 54, "1600hp 1180kW |de|1180.0 kW |es| 1600.0 HP" },
		{ 55, "1800hp 1330kW|de|1330.0 kW |es| 1800.0 HP " },
		{ 56, "2000hp 1480kW|de|1480.0 kW |es| 2000.0 HP " },
		{ 57, "2300hp 1700kW|de|1700.0 kW |es| 2300.0 HP " },
		{ 58, "2500hp 1840kW |de|1840.0 kW |es| 2500.0 HP" }
		DEFAULT_VALUE 4;
	}
}

COMMAND READ_P0404
{
	SLOT 1;
	INDEX 148;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0404 }
	}
}

WRITE_P0404 LIKE READ_P0404
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0404 }
		REPLY { }
	}
}

VARIABLE P0405
{
	LABEL "P0405 Encoder Pulses Number|de|P0405 Drehgeber PPR|es|P0405 Nmero Pulsos Encoder";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1024;
		MIN_VALUE 100;
		MAX_VALUE 9999;
	}
	CONSTANT_UNIT "ppr";
}

COMMAND READ_P0405
{
	SLOT 1;
	INDEX 149;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0405 }
	}
}

WRITE_P0405 LIKE READ_P0405
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0405 }
		REPLY { }
	}
}

VARIABLE P0406
{
	LABEL "P0406 Motor Ventilation|de|P0406 Motor Lfter|es|P0406 Tipo Ventilacin";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Self-Vent.|de|Eigenlfter|es|Autoventilado" },
		{ 1, "Separate Vent.|de|Fremdlfter|es|Independiente" },
		{ 2, "Optimal Flux|de|Optimalfluss|es|Flujo ptimo" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0406
{
	SLOT 1;
	INDEX 150;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0406 }
	}
}

WRITE_P0406 LIKE READ_P0406
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0406 }
		REPLY { }
	}
}

VARIABLE P0407
{
	LABEL "P0407 Motor Rated Power Fac|de|P0407 Motor Leistungsfaktor|es|P0407 Factor Pot.Nom. Motor";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
}

COMMAND READ_P0407
{
	SLOT 1;
	INDEX 151;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0407 }
	}
}

WRITE_P0407 LIKE READ_P0407
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0407 }
		REPLY { }
	}
}

VARIABLE P0409
{
	LABEL "P0409 Stator Resistance    |de|P0409 Statorwiderstand|es|P0409 Resistencia Estator";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
	CONSTANT_UNIT "ohm";
}

COMMAND READ_P0409
{
	SLOT 1;
	INDEX 153;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0409 }
	}
}

WRITE_P0409 LIKE READ_P0409
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0409 }
		REPLY { }
	}
}

VARIABLE P0410
{
	LABEL "P0410 Magnetization Current|de|P0410 Magnetisierungsstrom|es|P0410 Corr. Magnetizacin ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "A";
}

COMMAND READ_P0410
{
	SLOT 1;
	INDEX 154;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0410 }
	}
}

WRITE_P0410 LIKE READ_P0410
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0410 }
		REPLY { }
	}
}

VARIABLE P0411
{
	LABEL "P0411 Leakage Inductance|de|P0411 Streuinduktivitt|es|P0411 Induct. Dispersin";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "mH";
}

COMMAND READ_P0411
{
	SLOT 1;
	INDEX 155;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0411 }
	}
}

WRITE_P0411 LIKE READ_P0411
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0411 }
		REPLY { }
	}
}

VARIABLE P0412
{
	LABEL "P0412 Tr Time Constant  |de|P0412 Tr Zeitkonstante|es|P0412 Constante Tr ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0412
{
	SLOT 1;
	INDEX 156;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0412 }
	}
}

WRITE_P0412 LIKE READ_P0412
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0412 }
		REPLY { }
	}
}

VARIABLE P0413
{
	LABEL "P0413 Tm Time Constant|de|P0413 Tm Zeitkonstante|es|P0413 Constante Tm    ";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.01;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0413
{
	SLOT 1;
	INDEX 157;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0413 }
	}
}

WRITE_P0413 LIKE READ_P0413
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0413 }
		REPLY { }
	}
}

VARIABLE P0520
{
	LABEL "P0520 PID Proportional Gain|de|P0520 PID P Verstrkung|es|P0520 Ganancia Prop. PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0520
{
	SLOT 2;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0520 }
	}
}

WRITE_P0520 LIKE READ_P0520
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0520 }
		REPLY { }
	}
}

VARIABLE P0521
{
	LABEL "P0521 PID Integral Gain|de|P0521 PID I Verstrkung|es|P0521 Ganancia Integral PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0521
{
	SLOT 2;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0521 }
	}
}

WRITE_P0521 LIKE READ_P0521
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0521 }
		REPLY { }
	}
}

VARIABLE P0522
{
	LABEL "P0522 PID Differential Gain|de|P0522 PID D Verstrkung|es|P0522 Ganancia Deriv. PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.001;
	}
}

COMMAND READ_P0522
{
	SLOT 2;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0522 }
	}
}

WRITE_P0522 LIKE READ_P0522
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0522 }
		REPLY { }
	}
}

VARIABLE P0523
{
	LABEL "P0523 PID Ramp Time|de|P0523 PID Rampenzeit|es|P0523 Tiempo Rampa PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "s";
}

COMMAND READ_P0523
{
	SLOT 2;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0523 }
	}
}

WRITE_P0523 LIKE READ_P0523
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0523 }
		REPLY { }
	}
}

VARIABLE P0524
{
	LABEL "P0524 PID Feedback Sel.|de|P0524 PID Feedback Ausw.|es|P0524 Sel. Realim. PID";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "AI1 (P0231)|de|AI1 (P0231)|es|AI1 (P0231)" },
		{ 1, "AI2 (P0236)|de|AI2 (P0236)|es|AI2 (P0236)" },
		{ 2, "AI3 (P0241)|de|AI3 (P0241)|es|AI3 (P0241)" },
		{ 3, "AI4 (P0246)|de|AI4 (P0246)|es|AI4 (P0246)" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0524
{
	SLOT 2;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0524 }
	}
}

WRITE_P0524 LIKE READ_P0524
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0524 }
		REPLY { }
	}
}

VARIABLE P0525
{
	LABEL "P0525 Keypad PID Setpoint|de|P0525 PID Sollwert FB|es|P0525 Setpoint PID por HMI";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0525
{
	SLOT 2;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0525 }
	}
}

WRITE_P0525 LIKE READ_P0525
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0525 }
		REPLY { }
	}
}

VARIABLE P0527
{
	LABEL "P0527 PID Action Type|de|P0527 PID Regelkreis|es|P0527 Tipo de Accin  ";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Direct|de|Direct|es|Directo   " },
		{ 1, "Reverse|de|Invers|es|Reverso   " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0527
{
	SLOT 2;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0527 }
	}
}

WRITE_P0527 LIKE READ_P0527
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0527 }
		REPLY { }
	}
}

VARIABLE P0528
{
	LABEL "P0528 Proc. V. Scale Factor|de|P0528 Proz.Var. Skalafaktor|es|P0528 Factor Escala VP";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1000;
		MIN_VALUE 1;
		MAX_VALUE 9999;
	}
}

COMMAND READ_P0528
{
	SLOT 2;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0528 }
	}
}

WRITE_P0528 LIKE READ_P0528
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0528 }
		REPLY { }
	}
}

VARIABLE P0529
{
	LABEL "P0529 Proc.V. Decimal Point|de|P0529 Proz.Var. Dezimalpkt.|es|P0529 Punto Decimal VP";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "wxyz|de|wxyz|es|wxyz" },
		{ 1, "wxy.z|de|wxy.z|es|wxy.z" },
		{ 2, "wx.yz|de|wx.yz|es|wx.yz" },
		{ 3, "w.xyz|de|w.xyz|es|w.xyz" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0529
{
	SLOT 2;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0529 }
	}
}

WRITE_P0529 LIKE READ_P0529
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0529 }
		REPLY { }
	}
}

VARIABLE P0530
{
	LABEL "P0530 Proc. V. Eng. Unit 1|de|P0530 1. Einheit Proz. Var.|es|P0530 Unidad Ing. VP1";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 37;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0530
{
	SLOT 2;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0530 }
	}
}

WRITE_P0530 LIKE READ_P0530
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0530 }
		REPLY { }
	}
}

VARIABLE P0531
{
	LABEL "P0531 Proc. V. Eng. Unit 2|de|P0531 2. Einheit Proz. Var.|es|P0531 Unidad Ing. VP2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 32;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0531
{
	SLOT 2;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0531 }
	}
}

WRITE_P0531 LIKE READ_P0531
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0531 }
		REPLY { }
	}
}

VARIABLE P0532
{
	LABEL "P0532 Proc. V. Eng. Unit 3|de|P0532 3. Einheit Proz. Var.|es|P0532 Unidad Ing. VP3";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 32;
		MIN_VALUE 32;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0532
{
	SLOT 2;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0532 }
	}
}

WRITE_P0532 LIKE READ_P0532
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0532 }
		REPLY { }
	}
}

VARIABLE P0533
{
	LABEL "P0533 PVx Value|de|P0533 PVx Wert|es|P0533 Valor VPx";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0533
{
	SLOT 2;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0533 }
	}
}

WRITE_P0533 LIKE READ_P0533
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0533 }
		REPLY { }
	}
}

VARIABLE P0534
{
	LABEL "P0534 PVy Value|de|P0534 PVy Wert|es|P0534 Valor Vpy";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0534
{
	SLOT 2;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0534 }
	}
}

WRITE_P0534 LIKE READ_P0534
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0534 }
		REPLY { }
	}
}

VARIABLE P0535
{
	LABEL "P0535 Wake Up Band|de|P0535 Ausgang N=0 PID|es|P0535 Salida N=0 PID";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0535
{
	SLOT 2;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0535 }
	}
}

WRITE_P0535 LIKE READ_P0535
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0535 }
		REPLY { }
	}
}

VARIABLE P0536
{
	LABEL "P0536 P0525 Autom. Setting|de|P0536 P0525 autom. Einst.|es|P0536 Ajuste autom. P0525";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactivo  " },
		{ 1, "On        |de|Ein|es|Activo    " }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0536
{
	SLOT 2;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0536 }
	}
}

WRITE_P0536 LIKE READ_P0536
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0536 }
		REPLY { }
	}
}

VARIABLE P0550
{
	LABEL "P0550 Trigger Signal Source|de|P0550 Triggerquelle|es|P0550 Fuente Trigger Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer.|de|Drehz.Sollw.|es|Ref. Veloc." },
		{ 2, "Motor Speed|de|Motordrehz.|es|Veloc. Motor" },
		{ 3, "Motor Current|de|Motorstrom|es|Corr. Motor" },
		{ 4, "DC Link Volt.|de|ZwischenkrSpg.|es|Tensin CC" },
		{ 5, "Motor Freq.|de|Motorfrequenz|es|Frec. Motor" },
		{ 6, "Motor Voltage|de|Motorspg.|es|Tensin Salida" },
		{ 7, "Motor Torque|de|Motormoment|es|Torque Motor" },
		{ 8, "Process Var.|de|Prozessvar.|es|Var. Proceso" },
		{ 9, "Setpoint PID|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "AI1 |de|AI1 |es|AI1 " },
		{ 11, "AI2 |de|AI2 |es|AI2 " },
		{ 12, "AI3|de|AI3|es|AI3" },
		{ 13, "AI4|de|AI4|es|AI4" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0550
{
	SLOT 2;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0550 }
	}
}

WRITE_P0550 LIKE READ_P0550
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0550 }
		REPLY { }
	}
}

VARIABLE P0551
{
	LABEL "P0551 Trigger Level|de|P0551 Triggerlevel|es|P0551 Valor Trigger";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0551
{
	SLOT 2;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0551 }
	}
}

WRITE_P0551 LIKE READ_P0551
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0551 }
		REPLY { }
	}
}

VARIABLE P0552
{
	LABEL "P0552 Trigger Condition|de|P0552 Triggerbedingung|es|P0552 Condicin Trigger";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "P0550* = P0551|de|P0550* = P0551|es|P0550* = P0551" },
		{ 1, "P0550* <>P0551|de|P0550* <>P0551|es|P0550* <>P0551" },
		{ 2, "P0550* > P0551|de|P0550* > P0551|es|P0550* > P0551" },
		{ 3, "P0550* < P0551|de|P0550* < P0551|es|P0550* < P0551" },
		{ 4, "Alarm|de|Alarm |es|Alarma" },
		{ 5, "Fault|de|Fehler|es|Falla" },
		{ 6, "DIx|de|DIx |es|DIx" }
		DEFAULT_VALUE 5;
	}
}

COMMAND READ_P0552
{
	SLOT 2;
	INDEX 41;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0552 }
	}
}

WRITE_P0552 LIKE READ_P0552
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0552 }
		REPLY { }
	}
}

VARIABLE P0553
{
	LABEL "P0553 Trace Sampling Period|de|P0553 Trace Abtastzeit|es|P0553 Tiempo Muestreo Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 1;
		MIN_VALUE 1;
		MAX_VALUE 65535;
	}
}

COMMAND READ_P0553
{
	SLOT 2;
	INDEX 42;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0553 }
	}
}

WRITE_P0553 LIKE READ_P0553
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0553 }
		REPLY { }
	}
}

VARIABLE P0554
{
	LABEL "P0554 Trace Pre-Trigger|de|P0554 Trace Vortrigger|es|P0554 Pretrigger Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0554
{
	SLOT 2;
	INDEX 43;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0554 }
	}
}

WRITE_P0554 LIKE READ_P0554
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0554 }
		REPLY { }
	}
}

VARIABLE P0559
{
	LABEL "P0559 Trace Max. Memory|de|P0559 Trace max. Speicher|es|P0559 Memoria Mxima Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
}

COMMAND READ_P0559
{
	SLOT 2;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0559 }
	}
}

WRITE_P0559 LIKE READ_P0559
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0559 }
		REPLY { }
	}
}

VARIABLE P0560
{
	LABEL "P0560 Trace Avail. Memory|de|P0560 Trace verfg.Speicher|es|P0560 Memoria Dispon. Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 100;
	}
	CONSTANT_UNIT "%";
	HANDLING READ;
}

COMMAND READ_P0560
{
	SLOT 2;
	INDEX 49;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0560 }
	}
}

VARIABLE P0561
{
	LABEL "P0561 Trace Channel 1 (CH1)|de|P0561 Trace Kanal 1 (CH1)|es|P0561 CH1: Canal 1 Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer.|de|Drehz.Sollw.|es|Ref. Veloc." },
		{ 2, "Motor Speed|de|Motordrehz.|es|Veloc. Motor" },
		{ 3, "Motor Current|de|Motorstrom|es|Corr. Motor" },
		{ 4, "DC Link Volt.|de|ZwischenkrSpg.|es|Tensin CC" },
		{ 5, "Motor Freq.|de|Motorfrequenz|es|Frec. Motor" },
		{ 6, "Motor Voltage|de|Motorspg.|es|Tensin Salida" },
		{ 7, "Motor Torque|de|Motormoment|es|Torque Motor" },
		{ 8, "Process Var.|de|Prozessvar.|es|Var. Proceso" },
		{ 9, "Setpoint PID|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "AI1 |de|AI1 |es|AI1 " },
		{ 11, "AI2 |de|AI2 |es|AI2 " },
		{ 12, "AI3|de|AI3|es|AI3" },
		{ 13, "AI4|de|AI4|es|AI4" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0561
{
	SLOT 2;
	INDEX 50;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0561 }
	}
}

WRITE_P0561 LIKE READ_P0561
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0561 }
		REPLY { }
	}
}

VARIABLE P0562
{
	LABEL "P0562 Trace Channel 2 (CH2)|de|P0562 Trace Kanal 2 (CH2)|es|P0562 CH2: Canal 2 Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer.|de|Drehz.Sollw.|es|Ref. Veloc." },
		{ 2, "Motor Speed|de|Motordrehz.|es|Veloc. Motor" },
		{ 3, "Motor Current|de|Motorstrom|es|Corr. Motor" },
		{ 4, "DC Link Volt.|de|ZwischenkrSpg.|es|Tensin CC" },
		{ 5, "Motor Freq.|de|Motorfrequenz|es|Frec. Motor" },
		{ 6, "Motor Voltage|de|Motorspg.|es|Tensin Salida" },
		{ 7, "Motor Torque|de|Motormoment|es|Torque Motor" },
		{ 8, "Process Var.|de|Prozessvar.|es|Var. Proceso" },
		{ 9, "Setpoint PID|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "AI1 |de|AI1 |es|AI1 " },
		{ 11, "AI2 |de|AI2 |es|AI2 " },
		{ 12, "AI3|de|AI3|es|AI3" },
		{ 13, "AI4|de|AI4|es|AI4" }
		DEFAULT_VALUE 2;
	}
}

COMMAND READ_P0562
{
	SLOT 2;
	INDEX 51;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0562 }
	}
}

WRITE_P0562 LIKE READ_P0562
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0562 }
		REPLY { }
	}
}

VARIABLE P0563
{
	LABEL "P0563 Trace Channel 3 (CH3)|de|P0563 Trace Kanal 3 (CH3)|es|P0563 CH3: Canal 3 Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer.|de|Drehz.Sollw.|es|Ref. Veloc." },
		{ 2, "Motor Speed|de|Motordrehz.|es|Veloc. Motor" },
		{ 3, "Motor Current|de|Motorstrom|es|Corr. Motor" },
		{ 4, "DC Link Volt.|de|ZwischenkrSpg.|es|Tensin CC" },
		{ 5, "Motor Freq.|de|Motorfrequenz|es|Frec. Motor" },
		{ 6, "Motor Voltage|de|Motorspg.|es|Tensin Salida" },
		{ 7, "Motor Torque|de|Motormoment|es|Torque Motor" },
		{ 8, "Process Var.|de|Prozessvar.|es|Var. Proceso" },
		{ 9, "Setpoint PID|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "AI1 |de|AI1 |es|AI1 " },
		{ 11, "AI2 |de|AI2 |es|AI2 " },
		{ 12, "AI3|de|AI3|es|AI3" },
		{ 13, "AI4|de|AI4|es|AI4" }
		DEFAULT_VALUE 3;
	}
}

COMMAND READ_P0563
{
	SLOT 2;
	INDEX 52;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0563 }
	}
}

WRITE_P0563 LIKE READ_P0563
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0563 }
		REPLY { }
	}
}

VARIABLE P0564
{
	LABEL "P0564 Trace Channel 4 (CH4)|de|P0564 Trace Kanal 4 (CH4)|es|P0564 CH4: Canal 4 Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not selected|de|Aus|es|Inactivo  " },
		{ 1, "Speed Refer.|de|Drehz.Sollw.|es|Ref. Veloc." },
		{ 2, "Motor Speed|de|Motordrehz.|es|Veloc. Motor" },
		{ 3, "Motor Current|de|Motorstrom|es|Corr. Motor" },
		{ 4, "DC Link Volt.|de|ZwischenkrSpg.|es|Tensin CC" },
		{ 5, "Motor Freq.|de|Motorfrequenz|es|Frec. Motor" },
		{ 6, "Motor Voltage|de|Motorspg.|es|Tensin Salida" },
		{ 7, "Motor Torque|de|Motormoment|es|Torque Motor" },
		{ 8, "Process Var.|de|Prozessvar.|es|Var. Proceso" },
		{ 9, "Setpoint PID|de|PID Sollwert|es|Setpoint PID" },
		{ 10, "AI1 |de|AI1 |es|AI1 " },
		{ 11, "AI2 |de|AI2 |es|AI2 " },
		{ 12, "AI3|de|AI3|es|AI3" },
		{ 13, "AI4|de|AI4|es|AI4" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0564
{
	SLOT 2;
	INDEX 53;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0564 }
	}
}

WRITE_P0564 LIKE READ_P0564
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0564 }
		REPLY { }
	}
}

VARIABLE P0571
{
	LABEL "P0571 Start Trace Function|de|P0571 Start Trace-Funktion|es|P0571 Inicia Funcion Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactivo  " },
		{ 1, "On        |de|Ein|es|Activo    " }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0571
{
	SLOT 2;
	INDEX 60;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0571 }
	}
}

WRITE_P0571 LIKE READ_P0571
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0571 }
		REPLY { }
	}
}

VARIABLE P0572
{
	LABEL "P0572 Trace Trig. Day/Month|de|P0572 Trace Trig. Tag/Monat|es|P0572 Da/Mes Disparo Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0572 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0572
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0572 = (P0572&0x00FF) + (P0572>>8)*100; }
}

COMMAND READ_P0572
{
	SLOT 2;
	INDEX 61;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0572 }
	}
}

VARIABLE P0573
{
	LABEL "P0573 Trace Trig. Year|de|P0573 Trace Trig. Jahr|es|P0573 Ao Disparo Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 99;
	}
	HANDLING READ;
}

COMMAND READ_P0573
{
	SLOT 2;
	INDEX 62;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0573 }
	}
}

VARIABLE P0574
{
	LABEL "P0574 Trace Trig. Time|de|P0574 Trace Trig. Zeit|es|P0574 Hora Disparo Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

	}
	POST_READ_ACTIONS { ConvertToDateTimeP0574 }
	HELP [DATE_TIME_HELP];
	HANDLING READ;
}

METHOD ConvertToDateTimeP0574
{
	LABEL "Convert to day/month or hour/minute";
	DEFINITION { P0574 = (P0574&0x00FF) + (P0574>>8)*100; }
}

COMMAND READ_P0574
{
	SLOT 2;
	INDEX 63;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0574 }
	}
}

VARIABLE P0575
{
	LABEL "P0575 Trace Trig. Seconds|de|P0575 Trace Trig. Sekunden|es|P0575 Seg. Disparo Trace";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 59;
	}
	HANDLING READ;
}

COMMAND READ_P0575
{
	SLOT 2;
	INDEX 64;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0575 }
	}
}

VARIABLE P0576
{
	LABEL "P0576 Trace Function Status|de|P0576 Trace Status|es|P0576 Estado Funcin Trace";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Off       |de|Aus|es|Inactivo  " },
		{ 1, "Waiting|de|Warten|es|Aguardando" },
		{ 2, "Trigger|de|Triggern|es|Trigger" },
		{ 3, "Concluded|de|Fertig|es|Concluido" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0576
{
	SLOT 2;
	INDEX 65;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0576 }
	}
}

VARIABLE P0681
{
	LABEL "P0681 Speed in 13 bits|de|P0681 Drehzahl in 13 bits|es|P0681 Velocidad 13 bits";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
	HANDLING READ;
}

COMMAND READ_P0681
{
	SLOT 2;
	INDEX 170;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0681 }
	}
}

VARIABLE P0682
{
	LABEL "P0682 Serial/USB Control|de|P0682 Serielle/USB Kontr.|es|P0682 Control Serie/USB";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0682
{
	SLOT 2;
	INDEX 171;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0682 }
	}
}

VARIABLE P0683
{
	LABEL "P0683 Serial/USB Speed Ref.|de|P0683 Ser/USB Drehz Sollw.|es|P0683 Ref. Vel. Serie/USB";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
	HANDLING READ;
}

COMMAND READ_P0683
{
	SLOT 2;
	INDEX 172;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0683 }
	}
}

VARIABLE P0684
{
	LABEL "P0684 CANopen/DNet Control|de|P0684 CANop/DNet Kontrolle]|es|P0684 Control CANopen/DNet";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0684
{
	SLOT 2;
	INDEX 173;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0684 }
	}
}

VARIABLE P0685
{
	LABEL "P0685 CANop./DNet Speed Ref|de|P0685 CANop/DNet DrehzSollw|es|P0685 Ref. Vel. CANop./DNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
	HANDLING READ;
}

COMMAND READ_P0685
{
	SLOT 2;
	INDEX 174;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0685 }
	}
}

VARIABLE P0687
{
	LABEL "P0687 Anybus-CC Speed Ref.|de|P0687 Anybus-CC Drehz Sollw|es|P0687 Ref. Vel. Anybus-CC";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P0687
{
	SLOT 2;
	INDEX 176;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0687 }
	}
}

WRITE_P0687 LIKE READ_P0687
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0687 }
		REPLY { }
	}
}

VARIABLE P0692
{
	LABEL "P0692 Operation Mode Status|de|P0692 Operationsmod. Status|es|P0692 Estados Modo.Operac.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0692
{
	SLOT 2;
	INDEX 181;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0692 }
	}
}

VARIABLE P0693
{
	LABEL "P0693 Operation ModeCommand|de|P0693 Operationsmod. Komm.|es|P0693 Comandos Modo Oper.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
}

COMMAND READ_P0693
{
	SLOT 2;
	INDEX 182;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0693 }
	}
}

WRITE_P0693 LIKE READ_P0693
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0693 }
		REPLY { }
	}
}

VARIABLE P0696
{
	LABEL "P0696 AOx Value 1|de|P0696 1. AOx Wert|es|P0696 Valor 1 para AOx";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P0696
{
	SLOT 2;
	INDEX 185;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0696 }
	}
}

WRITE_P0696 LIKE READ_P0696
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0696 }
		REPLY { }
	}
}

VARIABLE P0697
{
	LABEL "P0697 AOx Value 2|de|P0697 2. AOx Wert|es|P0697 Valor 2 para AOx";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P0697
{
	SLOT 2;
	INDEX 186;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0697 }
	}
}

WRITE_P0697 LIKE READ_P0697
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0697 }
		REPLY { }
	}
}

VARIABLE P0698
{
	LABEL "P0698 AOx Value 3|de|P0698 3. AOx Wert|es|P0698 Valor 3 para AOx";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P0698
{
	SLOT 2;
	INDEX 187;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0698 }
	}
}

WRITE_P0698 LIKE READ_P0698
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0698 }
		REPLY { }
	}
}

VARIABLE P0699
{
	LABEL "P0699 AOx Value 4|de|P0699 4. AOx Wert|es|P0699 Valor 4 para AOx";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P0699
{
	SLOT 2;
	INDEX 188;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0699 }
	}
}

WRITE_P0699 LIKE READ_P0699
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0699 }
		REPLY { }
	}
}

VARIABLE P0700
{
	LABEL "P0700 CAN Protocol|de|P0700 CAN Protokoll|es|P0700 Protocolo CAN";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 1, "CANopen|de|CANopen|es|CANopen" },
		{ 2, "DeviceNet|de|DeviceNet|es|DeviceNet" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0700
{
	SLOT 2;
	INDEX 189;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0700 }
	}
}

WRITE_P0700 LIKE READ_P0700
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0700 }
		REPLY { }
	}
}

VARIABLE P0701
{
	LABEL "P0701 CAN Address|de|P0701 CAN Adresse|es|P0701 Direccin CAN";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 63;
		MIN_VALUE 0;
		MAX_VALUE 127;
	}
}

COMMAND READ_P0701
{
	SLOT 2;
	INDEX 190;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0701 }
	}
}

WRITE_P0701 LIKE READ_P0701
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0701 }
		REPLY { }
	}
}

VARIABLE P0702
{
	LABEL "P0702 CAN Baud Rate|de|P0702 CAN Baudrate|es|P0702 Tasa Comunicacin CAN";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "1 Mbit/s|de|1 Mbit/s|es|1 Mbit/s" },
		{ 1, "Reserved|de|Reserviert|es|Reservado" },
		{ 2, "500 Kbit/s|de|500 Kbit/s|es|500 Kbit/s" },
		{ 3, "250 Kbit/s|de|250 Kbit/s|es|250 Kbit/s" },
		{ 4, "125 Kbit/s|de|125 Kbit/s|es|125 Kbit/s" },
		{ 5, "100 Kbit/s|de|100 Kbit/s|es|100 Kbit/s" },
		{ 6, "50 Kbit/s|de|50 Kbit/s|es|50 Kbit/s" },
		{ 7, "20 Kbit/s|de|20 Kbit/s|es|20 Kbit/s" },
		{ 8, "10 Kbit/s|de|10 Kbit/s|es|10 Kbit/s" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0702
{
	SLOT 2;
	INDEX 191;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0702 }
	}
}

WRITE_P0702 LIKE READ_P0702
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0702 }
		REPLY { }
	}
}

VARIABLE P0703
{
	LABEL "P0703 Bus Off Reset|de|P0703 Bus Off Reset|es|P0703 Reset de Bus Off";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Manual|de|Manual|es|Manual" },
		{ 1, "Automatic|de|Automatisch|es|Automtico" }
		DEFAULT_VALUE 1;
	}
}

COMMAND READ_P0703
{
	SLOT 2;
	INDEX 192;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0703 }
	}
}

WRITE_P0703 LIKE READ_P0703
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0703 }
		REPLY { }
	}
}

VARIABLE P0705
{
	LABEL "P0705 CAN Controller Status|de|P0705 CAN Controller Status|es|P0705 Estado ControladorCAN";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Deshabilitado" },
		{ 1, "Auto-baud|de|Auto-Baud|es|Auto-baud" },
		{ 2, "CAN Enabled|de|CAN aktiv|es|CAN Activo" },
		{ 3, "Warning|de|Warnung|es|Warning" },
		{ 4, "Error Passive|de|Passiv. Fehler|es|Error Passive" },
		{ 5, "Bus Off|de|Bus Off|es|Bus Off" },
		{ 6, "No Bus Power|de|Ohne Busvers.|es|No Alimentado" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0705
{
	SLOT 2;
	INDEX 194;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0705 }
	}
}

VARIABLE P0706
{
	LABEL "P0706 RX CAN Telegrams|de|P0706 RX CAN Telegramme|es|P0706 Telegramas CAN RX";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0706
{
	SLOT 2;
	INDEX 195;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0706 }
	}
}

VARIABLE P0707
{
	LABEL "P0707 TX CAN Telegrams|de|P0707 TX CAN Telegramme|es|P0707 Telegramas CAN TX";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0707
{
	SLOT 2;
	INDEX 196;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0707 }
	}
}

VARIABLE P0708
{
	LABEL "P0708 Bus Off Counter|de|P0708 Bus Off Zhler|es|P0708 Contador de Bus Off";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0708
{
	SLOT 2;
	INDEX 197;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0708 }
	}
}

VARIABLE P0709
{
	LABEL "P0709 CAN Lost Messages|de|P0709 CAN verl. Telegramme|es|P0709 Mensajes CAN Perdidas";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	HANDLING READ;
}

COMMAND READ_P0709
{
	SLOT 2;
	INDEX 198;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0709 }
	}
}

VARIABLE P0710
{
	LABEL "P0710 DNet I/O instances|de|P0710 DNet I/O Instanzen|es|P0710 Instancias I/O DNet";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 7;
	}
}

COMMAND READ_P0710
{
	SLOT 2;
	INDEX 199;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0710 }
	}
}

WRITE_P0710 LIKE READ_P0710
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0710 }
		REPLY { }
	}
}

VARIABLE P0711
{
	LABEL "P0711 DNet Read Word #3|de|P0711 DNet Lese Wort #3|es|P0711 Lectura #3 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0711
{
	SLOT 2;
	INDEX 200;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0711 }
	}
}

WRITE_P0711 LIKE READ_P0711
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0711 }
		REPLY { }
	}
}

VARIABLE P0712
{
	LABEL "P0712 DNet Read Word #4|de|P0712 DNet Lese Wort #4|es|P0712 Lectura #4 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0712
{
	SLOT 2;
	INDEX 201;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0712 }
	}
}

WRITE_P0712 LIKE READ_P0712
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0712 }
		REPLY { }
	}
}

VARIABLE P0713
{
	LABEL "P0713 DNet Read Word #5|de|P0713 DNet Lese Wort #5|es|P0713 Lectura #5 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0713
{
	SLOT 2;
	INDEX 202;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0713 }
	}
}

WRITE_P0713 LIKE READ_P0713
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0713 }
		REPLY { }
	}
}

VARIABLE P0714
{
	LABEL "P0714 DNet Read Word #6|de|P0714 DNet Lese Wort #6|es|P0714 Lectura #6 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0714
{
	SLOT 2;
	INDEX 203;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0714 }
	}
}

WRITE_P0714 LIKE READ_P0714
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0714 }
		REPLY { }
	}
}

VARIABLE P0715
{
	LABEL "P0715 DNet Write Word #3|de|P0715 DNet Schreibe Wort #3|es|P0715 Escrita #3 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0715
{
	SLOT 2;
	INDEX 204;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0715 }
	}
}

WRITE_P0715 LIKE READ_P0715
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0715 }
		REPLY { }
	}
}

VARIABLE P0716
{
	LABEL "P0716 DNet Write Word #4|de|P0716 DNet Schreibe Wort #4|es|P0716 Escrita #4 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0716
{
	SLOT 2;
	INDEX 205;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0716 }
	}
}

WRITE_P0716 LIKE READ_P0716
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0716 }
		REPLY { }
	}
}

VARIABLE P0717
{
	LABEL "P0717 DNet Write Word #5|de|P0717 DNet Schreibe Wort #5|es|P0717 Escrita #5 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0717
{
	SLOT 2;
	INDEX 206;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0717 }
	}
}

WRITE_P0717 LIKE READ_P0717
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0717 }
		REPLY { }
	}
}

VARIABLE P0718
{
	LABEL "P0718 DNet Write Word #6|de|P0718 DNet Schreibe Wort #6|es|P0718 Escrita #6 DeviceNet";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE -1;
		MIN_VALUE -1;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0718
{
	SLOT 2;
	INDEX 207;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0718 }
	}
}

WRITE_P0718 LIKE READ_P0718
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0718 }
		REPLY { }
	}
}

VARIABLE P0719
{
	LABEL "P0719 DNet Network Status|de|P0719 DNet Netzwerk Status|es|P0719 Estado Red DeviceNet";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Offline|de|Offline|es|Offline" },
		{ 1, "OnLine,NotConn|de|OnLine,o.Verb.|es|OnLine,No Con." },
		{ 2, "OnLine,Conn|de|OnLine, Verb.|es|OnLine Conect." },
		{ 3, "Conn.Timed-out|de|Verb. Timeout|es|ConexinExpir" },
		{ 4, "Link Failure|de|Verb. Fehler|es|Falla Conexin" },
		{ 5, "Auto-Baud|de|Auto-Baud|es|Auto-Baud" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0719
{
	SLOT 2;
	INDEX 208;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0719 }
	}
}

VARIABLE P0720
{
	LABEL "P0720 DNet Master Status|de|P0720 DNet Master Status|es|P0720 Estado Maestro DNet";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Run|de|Run|es|Run" },
		{ 1, "Idle|de|Idle|es|Idle" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0720
{
	SLOT 2;
	INDEX 209;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0720 }
	}
}

VARIABLE P0721
{
	LABEL "P0721 CANopen Comm. Status|de|P0721 CANopen Komm. Status|es|P0721 Estado Com. CANopen";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Deshabilitado" },
		{ 1, "Reserved|de|Reserviert|es|Reservado" },
		{ 2, "Comm. Enabled|de|Komm. Ein|es|Comunic. Hab." },
		{ 3, "ErrorCtrl.Enab|de|ErrorCtrl.Enab|es|CtrlErroresHab" },
		{ 4, "Guarding Error|de|Guarding Error|es|Error Guarding" },
		{ 5, "HeartbeatError|de|HeartbeatError|es|ErrorHeartbeat" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0721
{
	SLOT 2;
	INDEX 210;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0721 }
	}
}

VARIABLE P0722
{
	LABEL "P0722 CANopen Node State|de|P0722 CANopen Knoten Status|es|P0722 Estado Nudo CANopen";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Deshabilitado" },
		{ 1, "Initialization|de|Initialisier.|es|Inicializacin" },
		{ 2, "Stopped|de|Stop|es|Parado" },
		{ 3, "Operational|de|Operational|es|Operacional" },
		{ 4, "PreOperational|de|Voroperational|es|Preoperacional" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0722
{
	SLOT 2;
	INDEX 211;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0722 }
	}
}

VARIABLE P0723
{
	LABEL "P0723 Anybus Identification|de|P0723 Identifikation Anybus|es|P0723 Identificacin Anybus";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Deshabilitado" },
		{ 1, "RS232|de|RS232|es|RS232" },
		{ 2, "RS422|de|RS422|es|RS422" },
		{ 3, "USB|de|USB|es|USB" },
		{ 4, "Serial Server|de|Seriel. Server|es|Serial Server" },
		{ 5, "Bluetooth|de|Bluetooth|es|Bluetooth" },
		{ 6, "Zigbee|de|Zigbee|es|Zigbee" },
		{ 7, "Reserved|de|Reserviert|es|Reservado" },
		{ 8, "Reserved|de|Reserviert|es|Reservado" },
		{ 9, "Reserved|de|Reserviert|es|Reservado" },
		{ 10, "RS485|de|RS485|es|RS485" },
		{ 11, "Reserved|de|Reserviert|es|Reservado" },
		{ 12, "Reserved|de|Reserviert|es|Reservado" },
		{ 13, "Reserved|de|Reserviert|es|Reservado" },
		{ 14, "Reserved|de|Reserviert|es|Reservado" },
		{ 15, "Reserved|de|Reserviert|es|Reservado" },
		{ 16, "Profibus DP|de|Profibus DP|es|Profibus DP" },
		{ 17, "DeviceNet|de|DeviceNet|es|DeviceNet" },
		{ 18, "CANopen|de|CANopen|es|CANopen" },
		{ 19, "EtherNet/IP|de|EtherNet/IP|es|EtherNet/IP" },
		{ 20, "CC-Link|de|CC-Link|es|CC-Link" },
		{ 21, "Modbus-TCP|de|Modbus-TCP|es|Modbus-TCP" },
		{ 22, "Modbus-RTU|de|Modbus-RTU|es|Modbus-RTU" },
		{ 23, "Profinet IO|de|Profinet IO|es|Profinet IO" },
		{ 24, "Reserved|de|Reserviert|es|Reservado" },
		{ 25, "Reserved|de|Reserviert|es|Reservado" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0723
{
	SLOT 2;
	INDEX 212;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0723 }
	}
}

VARIABLE P0724
{
	LABEL "P0724 Anybus Comm. Status|de|P0724 Anybus Komm. Status|es|P0724 Estado Comunic.Anybus";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Inactivo" },
		{ 1, "Not Supported|de|Nicht unterst|es|No Soportado" },
		{ 2, "Access Error|de|Zugriffsfehler|es|Error Acceso" },
		{ 3, "Offline|de|Offline|es|Offline" },
		{ 4, "Online|de|Online|es|Online" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0724
{
	SLOT 2;
	INDEX 213;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0724 }
	}
}

VARIABLE P0725
{
	LABEL "P0725 Anybus Address|de|P0725 Anybus Adresse|es|P0725 Direccin Anybus";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 255;
	}
}

COMMAND READ_P0725
{
	SLOT 2;
	INDEX 214;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0725 }
	}
}

WRITE_P0725 LIKE READ_P0725
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0725 }
		REPLY { }
	}
}

VARIABLE P0726
{
	LABEL "P0726 Anybus Baud Rate|de|P0726 Anybus Baudrate|es|P0726 Tasa Comunic. Anybus";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 3;
	}
}

COMMAND READ_P0726
{
	SLOT 2;
	INDEX 215;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0726 }
	}
}

WRITE_P0726 LIKE READ_P0726
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0726 }
		REPLY { }
	}
}

VARIABLE P0727
{
	LABEL "P0727 Anybus I/O Words|de|P0727 Anybus I/O Worte|es|P0727 Palabras I/O Anybus";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 2;
		MIN_VALUE 2;
		MAX_VALUE 8;
	}
}

COMMAND READ_P0727
{
	SLOT 2;
	INDEX 216;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0727 }
	}
}

WRITE_P0727 LIKE READ_P0727
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0727 }
		REPLY { }
	}
}

VARIABLE P0728
{
	LABEL "P0728 Anybus Read Word #3|de|P0728 Anybus Lese Wort #3|es|P0728 Lectura #3 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0728
{
	SLOT 2;
	INDEX 217;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0728 }
	}
}

WRITE_P0728 LIKE READ_P0728
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0728 }
		REPLY { }
	}
}

VARIABLE P0729
{
	LABEL "P0729 Anybus Read Word #4|de|P0729 Anybus Lese Wort #4|es|P0729 Lectura #4 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0729
{
	SLOT 2;
	INDEX 218;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0729 }
	}
}

WRITE_P0729 LIKE READ_P0729
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0729 }
		REPLY { }
	}
}

VARIABLE P0730
{
	LABEL "P0730 Anybus Read Word #5|de|P0730 Anybus Lese Wort #5|es|P0730 Lectura #5 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0730
{
	SLOT 2;
	INDEX 219;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0730 }
	}
}

WRITE_P0730 LIKE READ_P0730
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0730 }
		REPLY { }
	}
}

VARIABLE P0731
{
	LABEL "P0731 Anybus Read Word #6|de|P0731 Anybus Lese Wort #6|es|P0731 Lectura #6 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0731
{
	SLOT 2;
	INDEX 220;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0731 }
	}
}

WRITE_P0731 LIKE READ_P0731
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0731 }
		REPLY { }
	}
}

VARIABLE P0732
{
	LABEL "P0732 Anybus Read Word #7|de|P0732 Anybus Lese Wort #7|es|P0732 Lectura #7 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0732
{
	SLOT 2;
	INDEX 221;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0732 }
	}
}

WRITE_P0732 LIKE READ_P0732
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0732 }
		REPLY { }
	}
}

VARIABLE P0733
{
	LABEL "P0733 Anybus Read Word #8|de|P0733 Anybus Lese Wort #8|es|P0733 Lectura #8 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0733
{
	SLOT 2;
	INDEX 222;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0733 }
	}
}

WRITE_P0733 LIKE READ_P0733
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0733 }
		REPLY { }
	}
}

VARIABLE P0734
{
	LABEL "P0734 Anybus Write Word #3|de|P0734 Anybus Schr. Wort #3|es|P0734 Escrita #3 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0734
{
	SLOT 2;
	INDEX 223;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0734 }
	}
}

WRITE_P0734 LIKE READ_P0734
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0734 }
		REPLY { }
	}
}

VARIABLE P0735
{
	LABEL "P0735 Anybus Write Word #4|de|P0735 Anybus Schr. Wort #4|es|P0735 Escrita #4 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0735
{
	SLOT 2;
	INDEX 224;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0735 }
	}
}

WRITE_P0735 LIKE READ_P0735
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0735 }
		REPLY { }
	}
}

VARIABLE P0736
{
	LABEL "P0736 Anybus Write Word #5|de|P0736 Anybus Schr. Wort #5|es|P0736 Escrita #5 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0736
{
	SLOT 2;
	INDEX 225;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0736 }
	}
}

WRITE_P0736 LIKE READ_P0736
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0736 }
		REPLY { }
	}
}

VARIABLE P0737
{
	LABEL "P0737 Anybus Write Word #6|de|P0737 Anybus Schr. Wort #6|es|P0737 Escrita #6 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0737
{
	SLOT 2;
	INDEX 226;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0737 }
	}
}

WRITE_P0737 LIKE READ_P0737
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0737 }
		REPLY { }
	}
}

VARIABLE P0738
{
	LABEL "P0738 Anybus Write Word #7|de|P0738 Anybus Schr. Wort #7|es|P0738 Escrita #7 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0738
{
	SLOT 2;
	INDEX 227;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0738 }
	}
}

WRITE_P0738 LIKE READ_P0738
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0738 }
		REPLY { }
	}
}

VARIABLE P0739
{
	LABEL "P0739 Anybus Write Word #8|de|P0739 Anybus Schr. Wort #8|es|P0739 Escrita #8 Anybus";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 1299;
	}
}

COMMAND READ_P0739
{
	SLOT 2;
	INDEX 228;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0739 }
	}
}

WRITE_P0739 LIKE READ_P0739
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0739 }
		REPLY { }
	}
}

VARIABLE P0740
{
	LABEL "P0740 Profibus Comm. Status|de|P0740 Profibus Komm. Status|es|P0740 Estado Com. Profibus";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Disabled|de|Aus|es|Inactivo" },
		{ 1, "Not Supported|de|Nicht unterst|es|No Soportado" },
		{ 2, "Access Error|de|Zugriffsfehler|es|Error Acceso" },
		{ 3, "Offline|de|Offline|es|Offline" },
		{ 4, "Online|de|Online|es|Online" }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P0740
{
	SLOT 2;
	INDEX 229;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0740 }
	}
}

VARIABLE P0800
{
	LABEL "P0800 Phase U Book 1 Temper|de|P0800 Phase U Modul 1 Temp.|es|P0800 Temper. Fase U Book 1";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0800
{
	SLOT 3;
	INDEX 34;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0800 }
	}
}

VARIABLE P0801
{
	LABEL "P0801 Phase V Book 1 Temper|de|P0801 Phase V Modul 1 Temp.|es|P0801 Temper. Fase V Book 1";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0801
{
	SLOT 3;
	INDEX 35;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0801 }
	}
}

VARIABLE P0802
{
	LABEL "P0802 Phase W Book 1 Temper|de|P0802 Phase W Modul 1 Temp.|es|P0802 Temper. Fase W Book 1";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0802
{
	SLOT 3;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0802 }
	}
}

VARIABLE P0803
{
	LABEL "P0803 Phase U Book 2 Temper|de|P0803 Phase U Modul 2 Temp.|es|P0803 Temper. Fase U Book 2";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0803
{
	SLOT 3;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0803 }
	}
}

VARIABLE P0804
{
	LABEL "P0804 Phase V Book 2 Temper|de|P0804 Phase V Modul 2 Temp.|es|P0804 Temper. Fase V Book 2";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0804
{
	SLOT 3;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0804 }
	}
}

VARIABLE P0805
{
	LABEL "P0805 Phase W Book 2 Temper|de|P0805 Phase W Modul 2 Temp.|es|P0805 Temper. Fase W Book 2";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0805
{
	SLOT 3;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0805 }
	}
}

VARIABLE P0806
{
	LABEL "P0806 Phase U Book 3 Temper|de|P0806 Phase U Modul 3 Temp.|es|P0806 Temper. Fase U Book 3";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0806
{
	SLOT 3;
	INDEX 40;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0806 }
	}
}

VARIABLE P0807
{
	LABEL "P0807 Phase V Book 3 Temper|de|P0807 Phase V Modul 3 Temp.|es|P0807 Temper. Fase V Book 3";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0807
{
	SLOT 3;
	INDEX 41;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0807 }
	}
}

VARIABLE P0808
{
	LABEL "P0808 Phase W Book 3 Temper|de|P0808 Phase W Modul 3 Temp.|es|P0808 Temper. Fase W Book 3";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0808
{
	SLOT 3;
	INDEX 42;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0808 }
	}
}

VARIABLE P0809
{
	LABEL "P0809 Phase U Book 4 Temper|de|P0809 Phase U Modul 4 Temp.|es|P0809 Temper. Fase U Book 4";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0809
{
	SLOT 3;
	INDEX 43;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0809 }
	}
}

VARIABLE P0810
{
	LABEL "P0810 Phase V Book 4 Temper|de|P0810 Phase V Modul 4 Temp.|es|P0810 Temper. Fase V Book 4";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0810
{
	SLOT 3;
	INDEX 44;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0810 }
	}
}

VARIABLE P0811
{
	LABEL "P0811 Phase W Book 4 Temper|de|P0811 Phase W Modul 4 Temp.|es|P0811 Temper. Fase W Book 4";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0811
{
	SLOT 3;
	INDEX 45;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0811 }
	}
}

VARIABLE P0812
{
	LABEL "P0812 Phase U Book 5 Temper|de|P0812 Phase U Modul 5 Temp.|es|P0812 Temper. Fase U Book 5";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0812
{
	SLOT 3;
	INDEX 46;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0812 }
	}
}

VARIABLE P0813
{
	LABEL "P0813 Phase V Book 5 Temper|de|P0813 Phase V Modul 5 Temp.|es|P0813 Temper. Fase V Book 5";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0813
{
	SLOT 3;
	INDEX 47;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0813 }
	}
}

VARIABLE P0814
{
	LABEL "P0814 Phase W Book 5 Temper|de|P0814 Phase W Modul 5 Temp.|es|P0814 Temper. Fase W Book 5";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{
		SCALING_FACTOR 0.1;
	}
	CONSTANT_UNIT "C";
	HANDLING READ;
}

COMMAND READ_P0814
{
	SLOT 3;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0814 }
	}
}

VARIABLE P0832
{
	LABEL "P0832 DIM1 Function|de|P0832 Funktion DIM1 Eingang|es|P0832 Funcin Entrada DIM1";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Extern Fault|de|Extern. Fehler|es|Falla Externa" },
		{ 2, "Refrig. Fault|de|Fehler Khlung|es|Falla Refrig." },
		{ 3, "Overtemp. Brk|de|temp. Bremsen|es|Sobret. Fren" },
		{ 4, "Overtemp. Ret.|de|temp.Gleichr.|es|Sobret. Retif" },
		{ 5, "High Temp. Ret|de|Hohe Temp. GR|es|Temp. Elev Ret" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0832
{
	SLOT 3;
	INDEX 66;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0832 }
	}
}

WRITE_P0832 LIKE READ_P0832
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0832 }
		REPLY { }
	}
}

VARIABLE P0833
{
	LABEL "P0833 DIM2 Function|de|P0833 Funktion DIM2 Eingang|es|P0833 Funcin Entrada DIM2";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Not Used  |de|Ohne Funktion|es|Sin Funcin " },
		{ 1, "Extern Fault|de|Extern. Fehler|es|Falla Externa" },
		{ 2, "Refrig. Fault|de|Fehler Khlung|es|Falla Refrig." },
		{ 3, "Overtemp. Brk|de|temp. Bremsen|es|Sobret. Fren" },
		{ 4, "Overtemp. Ret.|de|temp.Gleichr.|es|Sobret. Retif" },
		{ 5, "High Temp. Ret|de|Hohe Temp. GR|es|Temp. Elev Ret" }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P0833
{
	SLOT 3;
	INDEX 67;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0833 }
	}
}

WRITE_P0833 LIKE READ_P0833
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P0833 }
		REPLY { }
	}
}

VARIABLE P0834
{
	LABEL "P0834 DIM1 DIM2 Status|de|P0834 Status DIM1 DIM2|es|P0834 Estado DIM1 y DIM2";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 248;
	}
	HANDLING READ;
}

COMMAND READ_P0834
{
	SLOT 3;
	INDEX 68;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P0834 }
	}
}

VARIABLE P1000
{
	LABEL "P1000 SoftPLC Status|de|P1000 Status SoftPLC|es|P1000 Estado de la SoftPLC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "No Application|de|Ohne Anwendung|es|Sin Aplicacin" },
		{ 1, "Install. App.|de|Installiere|es|Instal. Aplic." },
		{ 2, "Incompat. App.|de|Inkompatibel|es|Aplic. Incomp." },
		{ 3, "App. Stopped|de|Gestoppt|es|Aplic. Parado" },
		{ 4, "App. Running|de|Anwend. Luft|es|Aplic." }
		DEFAULT_VALUE 0;
	}
	HANDLING READ;
}

COMMAND READ_P1000
{
	SLOT 3;
	INDEX 234;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1000 }
	}
}

VARIABLE P1001
{
	LABEL "P1001 SoftPLC Command|de|P1001 SoftPLC Steuerung|es|P1001 Comando para SoftPLC";
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, "Stop Program|de|Progr. stoppen|es|Para Aplic." },
		{ 1, "Run Program|de|Progr. starten|es|Ejecuta Aplic." },
		{ 2, "Delete Program|de|Progr. lschen|es|Quitar Aplic." }
		DEFAULT_VALUE 0;
	}
}

COMMAND READ_P1001
{
	SLOT 3;
	INDEX 235;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1001 }
	}
}

WRITE_P1001 LIKE READ_P1001
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1001 }
		REPLY { }
	}
}

VARIABLE P1002
{
	LABEL "P1002 Scan Cycle Time|de|P1002 Zeit Scanzyklus|es|P1002 Tiempo Ciclo de Ejec.";
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE 0;
		MAX_VALUE 65535;
	}
	CONSTANT_UNIT "ms";
	HANDLING READ;
}

COMMAND READ_P1002
{
	SLOT 3;
	INDEX 236;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1002 }
	}
}

VARIABLE P1010
{
	LABEL "P1010 SoftPLC Parameter 1|de|P1010 SoftPLC Parameter 1|es|P1010 Parmetro SoftPLC 1";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1010
{
	SLOT 3;
	INDEX 244;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1010 }
	}
}

WRITE_P1010 LIKE READ_P1010
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1010 }
		REPLY { }
	}
}

VARIABLE P1011
{
	LABEL "P1011 SoftPLC Parameter 2|de|P1011 SoftPLC Parameter 2|es|P1011 Parmetro SoftPLC 2";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1011
{
	SLOT 3;
	INDEX 245;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1011 }
	}
}

WRITE_P1011 LIKE READ_P1011
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1011 }
		REPLY { }
	}
}

VARIABLE P1012
{
	LABEL "P1012 SoftPLC Parameter 3|de|P1012 SoftPLC Parameter 3|es|P1012 Parmetro SoftPLC 3";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1012
{
	SLOT 3;
	INDEX 246;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1012 }
	}
}

WRITE_P1012 LIKE READ_P1012
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1012 }
		REPLY { }
	}
}

VARIABLE P1013
{
	LABEL "P1013 SoftPLC Parameter 4|de|P1013 SoftPLC Parameter 4|es|P1013 Parmetro SoftPLC 4";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1013
{
	SLOT 3;
	INDEX 247;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1013 }
	}
}

WRITE_P1013 LIKE READ_P1013
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1013 }
		REPLY { }
	}
}

VARIABLE P1014
{
	LABEL "P1014 SoftPLC Parameter 5|de|P1014 SoftPLC Parameter 5|es|P1014 Parmetro SoftPLC 5";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1014
{
	SLOT 3;
	INDEX 248;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1014 }
	}
}

WRITE_P1014 LIKE READ_P1014
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1014 }
		REPLY { }
	}
}

VARIABLE P1015
{
	LABEL "P1015 SoftPLC Parameter 6|de|P1015 SoftPLC Parameter 6|es|P1015 Parmetro SoftPLC 6";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1015
{
	SLOT 3;
	INDEX 249;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1015 }
	}
}

WRITE_P1015 LIKE READ_P1015
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1015 }
		REPLY { }
	}
}

VARIABLE P1016
{
	LABEL "P1016 SoftPLC Parameter 7|de|P1016 SoftPLC Parameter 7|es|P1016 Parmetro SoftPLC 7";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1016
{
	SLOT 3;
	INDEX 250;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1016 }
	}
}

WRITE_P1016 LIKE READ_P1016
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1016 }
		REPLY { }
	}
}

VARIABLE P1017
{
	LABEL "P1017 SoftPLC Parameter 8|de|P1017 SoftPLC Parameter 8|es|P1017 Parmetro SoftPLC 8";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1017
{
	SLOT 3;
	INDEX 251;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1017 }
	}
}

WRITE_P1017 LIKE READ_P1017
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1017 }
		REPLY { }
	}
}

VARIABLE P1018
{
	LABEL "P1018 SoftPLC Parameter 9|de|P1018 SoftPLC Parameter 9|es|P1018 Parmetro SoftPLC 9";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1018
{
	SLOT 3;
	INDEX 252;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1018 }
	}
}

WRITE_P1018 LIKE READ_P1018
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1018 }
		REPLY { }
	}
}

VARIABLE P1019
{
	LABEL "P1019 SoftPLC Parameter 10|de|P1019 SoftPLC Parameter 10|es|P1019 Parmetro SoftPLC 10";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1019
{
	SLOT 3;
	INDEX 253;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1019 }
	}
}

WRITE_P1019 LIKE READ_P1019
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1019 }
		REPLY { }
	}
}

VARIABLE P1020
{
	LABEL "P1020 SoftPLC Parameter 11|de|P1020 SoftPLC Parameter 11|es|P1020 Parmetro SoftPLC 11";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1020
{
	SLOT 3;
	INDEX 254;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1020 }
	}
}

WRITE_P1020 LIKE READ_P1020
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1020 }
		REPLY { }
	}
}

VARIABLE P1021
{
	LABEL "P1021 SoftPLC Parameter 12|de|P1021 SoftPLC Parameter 12|es|P1021 Parmetro SoftPLC 12";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1021
{
	SLOT 4;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1021 }
	}
}

WRITE_P1021 LIKE READ_P1021
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1021 }
		REPLY { }
	}
}

VARIABLE P1022
{
	LABEL "P1022 SoftPLC Parameter 13|de|P1022 SoftPLC Parameter 13|es|P1022 Parmetro SoftPLC 13";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1022
{
	SLOT 4;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1022 }
	}
}

WRITE_P1022 LIKE READ_P1022
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1022 }
		REPLY { }
	}
}

VARIABLE P1023
{
	LABEL "P1023 SoftPLC Parameter 14|de|P1023 SoftPLC Parameter 14|es|P1023 Parmetro SoftPLC 14";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1023
{
	SLOT 4;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1023 }
	}
}

WRITE_P1023 LIKE READ_P1023
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1023 }
		REPLY { }
	}
}

VARIABLE P1024
{
	LABEL "P1024 SoftPLC Parameter 15|de|P1024 SoftPLC Parameter 15|es|P1024 Parmetro SoftPLC 15";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1024
{
	SLOT 4;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1024 }
	}
}

WRITE_P1024 LIKE READ_P1024
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1024 }
		REPLY { }
	}
}

VARIABLE P1025
{
	LABEL "P1025 SoftPLC Parameter 16|de|P1025 SoftPLC Parameter 16|es|P1025 Parmetro SoftPLC 16";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1025
{
	SLOT 4;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1025 }
	}
}

WRITE_P1025 LIKE READ_P1025
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1025 }
		REPLY { }
	}
}

VARIABLE P1026
{
	LABEL "P1026 SoftPLC Parameter 17|de|P1026 SoftPLC Parameter 17|es|P1026 Parmetro SoftPLC 17";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1026
{
	SLOT 4;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1026 }
	}
}

WRITE_P1026 LIKE READ_P1026
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1026 }
		REPLY { }
	}
}

VARIABLE P1027
{
	LABEL "P1027 SoftPLC Parameter 18|de|P1027 SoftPLC Parameter 18|es|P1027 Parmetro SoftPLC 18";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1027
{
	SLOT 4;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1027 }
	}
}

WRITE_P1027 LIKE READ_P1027
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1027 }
		REPLY { }
	}
}

VARIABLE P1028
{
	LABEL "P1028 SoftPLC Parameter 19|de|P1028 SoftPLC Parameter 19|es|P1028 Parmetro SoftPLC 19";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1028
{
	SLOT 4;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1028 }
	}
}

WRITE_P1028 LIKE READ_P1028
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1028 }
		REPLY { }
	}
}

VARIABLE P1029
{
	LABEL "P1029 SoftPLC Parameter 20|de|P1029 SoftPLC Parameter 20|es|P1029 Parmetro SoftPLC 20";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1029
{
	SLOT 4;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1029 }
	}
}

WRITE_P1029 LIKE READ_P1029
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1029 }
		REPLY { }
	}
}

VARIABLE P1030
{
	LABEL "P1030 SoftPLC Parameter 21|de|P1030 SoftPLC Parameter 21|es|P1030 Parmetro SoftPLC 21";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1030
{
	SLOT 4;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1030 }
	}
}

WRITE_P1030 LIKE READ_P1030
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1030 }
		REPLY { }
	}
}

VARIABLE P1031
{
	LABEL "P1031 SoftPLC Parameter 22|de|P1031 SoftPLC Parameter 22|es|P1031 Parmetro SoftPLC 22";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1031
{
	SLOT 4;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1031 }
	}
}

WRITE_P1031 LIKE READ_P1031
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1031 }
		REPLY { }
	}
}

VARIABLE P1032
{
	LABEL "P1032 SoftPLC Parameter 23|de|P1032 SoftPLC Parameter 23|es|P1032 Parmetro SoftPLC 23";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1032
{
	SLOT 4;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1032 }
	}
}

WRITE_P1032 LIKE READ_P1032
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1032 }
		REPLY { }
	}
}

VARIABLE P1033
{
	LABEL "P1033 SoftPLC Parameter 24|de|P1033 SoftPLC Parameter 24|es|P1033 Parmetro SoftPLC 24";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1033
{
	SLOT 4;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1033 }
	}
}

WRITE_P1033 LIKE READ_P1033
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1033 }
		REPLY { }
	}
}

VARIABLE P1034
{
	LABEL "P1034 SoftPLC Parameter 25|de|P1034 SoftPLC Parameter 25|es|P1034 Parmetro SoftPLC 25";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1034
{
	SLOT 4;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1034 }
	}
}

WRITE_P1034 LIKE READ_P1034
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1034 }
		REPLY { }
	}
}

VARIABLE P1035
{
	LABEL "P1035 SoftPLC Parameter 26|de|P1035 SoftPLC Parameter 26|es|P1035 Parmetro SoftPLC 26";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1035
{
	SLOT 4;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1035 }
	}
}

WRITE_P1035 LIKE READ_P1035
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1035 }
		REPLY { }
	}
}

VARIABLE P1036
{
	LABEL "P1036 SoftPLC Parameter 27|de|P1036 SoftPLC Parameter 27|es|P1036 Parmetro SoftPLC 27";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1036
{
	SLOT 4;
	INDEX 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1036 }
	}
}

WRITE_P1036 LIKE READ_P1036
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1036 }
		REPLY { }
	}
}

VARIABLE P1037
{
	LABEL "P1037 SoftPLC Parameter 28|de|P1037 SoftPLC Parameter 28|es|P1037 Parmetro SoftPLC 28";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1037
{
	SLOT 4;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1037 }
	}
}

WRITE_P1037 LIKE READ_P1037
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1037 }
		REPLY { }
	}
}

VARIABLE P1038
{
	LABEL "P1038 SoftPLC Parameter 29|de|P1038 SoftPLC Parameter 29|es|P1038 Parmetro SoftPLC 29";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1038
{
	SLOT 4;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1038 }
	}
}

WRITE_P1038 LIKE READ_P1038
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1038 }
		REPLY { }
	}
}

VARIABLE P1039
{
	LABEL "P1039 SoftPLC Parameter 30|de|P1039 SoftPLC Parameter 30|es|P1039 Parmetro SoftPLC 30";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1039
{
	SLOT 4;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1039 }
	}
}

WRITE_P1039 LIKE READ_P1039
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1039 }
		REPLY { }
	}
}

VARIABLE P1040
{
	LABEL "P1040 SoftPLC Parameter 31|de|P1040 SoftPLC Parameter 31|es|P1040 Parmetro SoftPLC 31";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1040
{
	SLOT 4;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1040 }
	}
}

WRITE_P1040 LIKE READ_P1040
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1040 }
		REPLY { }
	}
}

VARIABLE P1041
{
	LABEL "P1041 SoftPLC Parameter 32|de|P1041 SoftPLC Parameter 32|es|P1041 Parmetro SoftPLC 32";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1041
{
	SLOT 4;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1041 }
	}
}

WRITE_P1041 LIKE READ_P1041
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1041 }
		REPLY { }
	}
}

VARIABLE P1042
{
	LABEL "P1042 SoftPLC Parameter 33|de|P1042 SoftPLC Parameter 33|es|P1042 Parmetro SoftPLC 33";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1042
{
	SLOT 4;
	INDEX 21;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1042 }
	}
}

WRITE_P1042 LIKE READ_P1042
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1042 }
		REPLY { }
	}
}

VARIABLE P1043
{
	LABEL "P1043 SoftPLC Parameter 34|de|P1043 SoftPLC Parameter 34|es|P1043 Parmetro SoftPLC 34";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1043
{
	SLOT 4;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1043 }
	}
}

WRITE_P1043 LIKE READ_P1043
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1043 }
		REPLY { }
	}
}

VARIABLE P1044
{
	LABEL "P1044 SoftPLC Parameter 35|de|P1044 SoftPLC Parameter 35|es|P1044 Parmetro SoftPLC 35";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1044
{
	SLOT 4;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1044 }
	}
}

WRITE_P1044 LIKE READ_P1044
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1044 }
		REPLY { }
	}
}

VARIABLE P1045
{
	LABEL "P1045 SoftPLC Parameter 36|de|P1045 SoftPLC Parameter 36|es|P1045 Parmetro SoftPLC 36";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1045
{
	SLOT 4;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1045 }
	}
}

WRITE_P1045 LIKE READ_P1045
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1045 }
		REPLY { }
	}
}

VARIABLE P1046
{
	LABEL "P1046 SoftPLC Parameter 37|de|P1046 SoftPLC Parameter 37|es|P1046 Parmetro SoftPLC 37";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1046
{
	SLOT 4;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1046 }
	}
}

WRITE_P1046 LIKE READ_P1046
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1046 }
		REPLY { }
	}
}

VARIABLE P1047
{
	LABEL "P1047 SoftPLC Parameter 38|de|P1047 SoftPLC Parameter 38|es|P1047 Parmetro SoftPLC 38";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1047
{
	SLOT 4;
	INDEX 26;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1047 }
	}
}

WRITE_P1047 LIKE READ_P1047
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1047 }
		REPLY { }
	}
}

VARIABLE P1048
{
	LABEL "P1048 SoftPLC Parameter 39|de|P1048 SoftPLC Parameter 39|es|P1048 Parmetro SoftPLC 39";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1048
{
	SLOT 4;
	INDEX 27;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1048 }
	}
}

WRITE_P1048 LIKE READ_P1048
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1048 }
		REPLY { }
	}
}

VARIABLE P1049
{
	LABEL "P1049 SoftPLC Parameter 40|de|P1049 SoftPLC Parameter 40|es|P1049 Parmetro SoftPLC 40";
	CLASS CONTAINED;
	TYPE INTEGER(2)
	{

		DEFAULT_VALUE 0;
		MIN_VALUE -32768;
		MAX_VALUE 32767;
	}
}

COMMAND READ_P1049
{
	SLOT 4;
	INDEX 28;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST { }
		REPLY { P1049 }
	}
}

WRITE_P1049 LIKE READ_P1049
{
	REDEFINE OPERATION WRITE;
	REDEFINE TRANSACTION
	{
		REQUEST { P1049 }
		REPLY { }
	}
}











