/**********************************************************************/
/**                                                                  **/
/** Copyright (c) 2007 WEG - All Rights reserved.                    **/
/**                                                                  **/
/** Device        : CFW-11 with Anybus-CC interface                  **/
/** Communication : PROFIBUS DP                                      **/
/**                                                                  **/
/**********************************************************************/


MANUFACTURER	268,
DEVICE_TYPE		2,
DEVICE_REVISION	110,
DD_REVISION		1,
EDD_PROFILE		0x03

#include "CFW11_Anybus_Vars.inc"
#include "CFW11_Anybus_Menus.inc"

/* Tableview */

MENU Table_Main_Specialist
{
	LABEL "CFW-11";
	ITEMS
	{
		M01,
		M04,
		M05,
		M06,
		M07,
		M08,
		M09
	}
}

MENU Table_Main_Maintenance
{
	LABEL "CFW-11";
	ITEMS
	{
		M01,
		M04,
		M05,
		M06,
		M07,
		M08,
		M09
	}
}

/* Menu */
MENU Menu_Main_Specialist
{
	LABEL "CFW-11";
	ITEMS
	{
		Menu_Device
	}
}

MENU Menu_Main_Maintenance
{
	LABEL "CFW-11";
	ITEMS
	{
		Menu_Device
	}
}

MENU Menu_Device
{
	LABEL "Device";
	ITEMS
	{
		Status_Control_Dialog,
		IO_Dialog,
		Charts_Dialog,
		Communication_Dialog,
		SEPARATOR,
		D01,
		SEPARATOR,
		Quick_Setup_Method
	}
}

/* IOs */
MENU IO_Dialog
{
	LABEL "I/O Configuration";
	STYLE DIALOG;
	ITEMS
	{
		DI_Page,
		DO_Page,
		AI_Page,
		AO_Page,
		DO_Control_Page,
		AO_Control_Page
	}
}

MENU DI_Page
{
	LABEL "DI";
	STYLE PAGE;
	ITEMS
	{
		P0012,
		COLUMNBREAK,
		P0263,
		P0264,
		P0265,
		P0266,
		P0267,
		P0268,
		P0269,
		P0270
	}
}

MENU DO_Page
{
	LABEL "DO";
	STYLE PAGE;
	ITEMS
	{
		P0013,
		COLUMNBREAK,
		P0275,
		P0276,
		P0277,
		P0278,
		P0279
	}
}

MENU AI_Page
{
	LABEL "AI";
	STYLE PAGE;
	ITEMS
	{
		P0230,
		ROWBREAK,
		AI1_Group,
		COLUMNBREAK,
		AI2_Group,
		ROWBREAK,
		AI3_Group,
		COLUMNBREAK,
		AI4_Group
	}
}

MENU AI1_Group
{
	LABEL "AI1";
	STYLE GROUP;
	ITEMS
	{
		P0018,
		P0231,
		P0232,
		P0233,
		P0234,
		P0235
	}
}

MENU AI2_Group
{
	LABEL "AI2";
	STYLE GROUP;
	ITEMS
	{
		P0019,
		P0236,
		P0237,
		P0238,
		P0239,
		P0240
	}
}

MENU AI3_Group
{
	LABEL "AI3";
	STYLE GROUP;
	ITEMS
	{
		P0020,
		P0241,
		P0242,
		P0243,
		P0244,
		P0245
	}
}

MENU AI4_Group
{
	LABEL "AI4";
	STYLE GROUP;
	ITEMS
	{
		P0021,
		P0246,
		P0247,
		P0248,
		P0249,
		P0250
	}
}

MENU AO_Page
{
	LABEL "AO";
	STYLE PAGE;
	ITEMS
	{
		AO1_Group,
		COLUMNBREAK,
		AO2_Group,
		ROWBREAK,
		AO3_Group,
		COLUMNBREAK,
		AO4_Group
	}
}

MENU AO1_Group
{
	LABEL "AO1";
	STYLE GROUP;
	ITEMS
	{
		P0014,
		P0251,
		P0252,
		P0253
	}
}

MENU AO2_Group
{
	LABEL "AO2";
	STYLE GROUP;
	ITEMS
	{
		P0015,
		P0254,
		P0255,
		P0256
	}
}

MENU AO3_Group
{
	LABEL "AO3";
	STYLE GROUP;
	ITEMS
	{
		P0016,
		P0257,
		P0258,
		P0259
	}
}

MENU AO4_Group
{
	LABEL "AO4";
	STYLE GROUP;
	ITEMS
	{
		P0017,
		P0260,
		P0261,
		P0262
	}
}

MENU DO_Control_Page
{
	LABEL "DO Control";
	STYLE PAGE;
	ITEMS
	{
		[DO_Control_Message],
		P0695
	}
}

MENU AO_Control_Page
{
	LABEL "AO Control";
	STYLE PAGE;
	ITEMS
	{
		[AO_Control_Message],
		P0696,
		P0697,
		P0698,
		P0699
	}
}


/* Status and control */
MENU Status_Control_Dialog
{
	LABEL [Status_Control_Dialog];
	STYLE DIALOG;
	ITEMS
	{
		Status_Control_Page,
		Control_Sources_Page
	}
}

MENU Status_Control_Page
{
	LABEL [Status_Control_Page];
	STYLE PAGE;
	ITEMS
	{
		P0680,
		COLUMNBREAK,
		P0686
	}
}

MENU Control_Sources_Page
{
	LABEL [Control_Sources_Page];
	STYLE PAGE;
	ITEMS
	{
		P0220,
		ROWBREAK,
		Local_Group,
		COLUMNBREAK,
		Remote_Group
	}
}

MENU Local_Group
{
	LABEL [Local_Group];
	STYLE GROUP;
	ITEMS
	{
		P0221,
		P0223,
		P0224,
		P0225
	}
}

MENU Remote_Group
{
	LABEL [Remote_Group];
	STYLE GROUP;
	ITEMS
	{
		P0222,
		P0226,
		P0227,
		P0228
	}
}


/* Charts */
MENU Charts_Dialog
{
	LABEL [Charts_Dialog];
	STYLE DIALOG;
	ITEMS
	{
		Chart_Page_1,
		Chart_Page_2,
		Chart_Page_3,
		Chart_Page_4,
		Chart_Page_5
	}
}

MENU Chart_Page_1
{
	LABEL [Motor_Speed];
	STYLE PAGE;
	ITEMS
	{
		Motor_Speed_Chart
	}
}

CHART Motor_Speed_Chart
{
	LABEL [Motor_Speed];
	TYPE STRIP;
	LENGTH 60 * 1000;
	CYCLE_TIME 1000;
	MEMBERS
	{
		member1, Motor_Speed_Source;
	}
}

SOURCE Motor_Speed_Source
{
	LABEL [Motor_Speed];
	Y_AXIS Motor_Speed_Axis;
	MEMBERS
	{
		member2, P0002;
	}
	INIT_ACTIONS
	{
		Update_P0134
	}
}

AXIS Motor_Speed_Axis
{
	LABEL [Motor_Speed];
	MIN_VALUE 0;
	MAX_VALUE P0134;
}

METHOD Update_P0134
{
	LABEL "";
	DEFINITION
	{
		ReadCommand(READ_P0134);
	}
}

MENU Chart_Page_2
{
	LABEL [Motor_Current];
	STYLE PAGE;
	ITEMS
	{
		Motor_Current_Chart
	}
}

CHART Motor_Current_Chart
{
	LABEL [Motor_Current];
	TYPE STRIP;
	LENGTH 60 * 1000;
	CYCLE_TIME 1000;
	MEMBERS
	{
		member3, Motor_Current_Source;
	}
}

SOURCE Motor_Current_Source
{
	LABEL [Motor_Current];
	MEMBERS
	{
		member4, P0003;
	}
}

MENU Chart_Page_3
{
	LABEL [Output_Voltage];
	STYLE PAGE;
	ITEMS
	{
		Output_Voltage_Chart
	}
}

CHART Output_Voltage_Chart
{
	LABEL [Output_Voltage];
	TYPE STRIP;
	LENGTH 60 * 1000;
	CYCLE_TIME 1000;
	MEMBERS
	{
		member5, Output_Voltage_Source;
	}
}

SOURCE Output_Voltage_Source
{
	LABEL [Output_Voltage];
	MEMBERS
	{
		member6, P0007;
	}
}

MENU Chart_Page_4
{
	LABEL [Motor_Torque];
	STYLE PAGE;
	ITEMS
	{
		Motor_Torque_Chart
	}
}

CHART Motor_Torque_Chart
{
	LABEL [Motor_Torque];
	TYPE STRIP;
	LENGTH 60 * 1000;
	CYCLE_TIME 1000;
	MEMBERS
	{
		member7, Motor_Torque_Source;
	}
}

SOURCE Motor_Torque_Source
{
	LABEL [Motor_Torque];
	MEMBERS
	{
		member8, P0009;
	}
}

MENU Chart_Page_5
{
	LABEL [PID_Process_Variable];
	STYLE PAGE;
	ITEMS
	{
		Process_Variable_Chart
	}
}

CHART Process_Variable_Chart
{
	LABEL [PID_Process_Variable];
	TYPE STRIP;
	LENGTH 60 * 1000;
	CYCLE_TIME 1000;
	MEMBERS
	{
		member9, Process_Variable_Source;
	}
}

SOURCE Process_Variable_Source
{
	LABEL [PID_Process_Variable];
	MEMBERS
	{
		member10, P0040;
	}
}


/* Communication configuration */
MENU Communication_Dialog
{
	LABEL [Communication_Dialog];
	STYLE DIALOG;
	ITEMS
	{
		[Reset_Warning],
		P0723,
		P0724,
		P0725,
		P0727,
		ROWBREAK,
		Read_Parameters_Group,
		COLUMNBREAK,
		Write_Parameters_Group
	}
}

MENU Read_Parameters_Group
{
	LABEL [Read_Parameters_Group];
	STYLE GROUP;
	ITEMS
	{
		[Anybus_Read_Word_1],

		[Anybus_Read_Word_2],

		P0728,
		P0729,
		P0730,
		P0731,
		P0732,
		P0733
	}
}

MENU Write_Parameters_Group
{
	LABEL [Write_Parameters_Group];
	STYLE GROUP;
	ITEMS
	{
		[Anybus_Write_Word_1],

		[Anybus_Write_Word_2],

		P0734,
		P0735,
		P0736,
		P0737,
		P0738,
		P0739
	}
}

/* Quick Setup */
METHOD Quick_Setup_Method
{
	LABEL "Quick Setup";
	DEFINITION
	{
		int state, result;

		ReadCommand(READ_P0201);
		ReadCommand(READ_P0296);
		ReadCommand(READ_P0298);
		ReadCommand(READ_P0400);
		ReadCommand(READ_P0401);
		ReadCommand(READ_P0403);
		ReadCommand(READ_P0402);
		ReadCommand(READ_P0404);
		ReadCommand(READ_P0406);

		state = 0;
		for (;;)
		{
			switch (state)
			{
				case 0:
                    MenuDisplay(QS_Drive_Dialog, "Cancel;Next", result);
                    if(result == 1) result = 2;
                    break;
				case 1:
                    MenuDisplay(QS_Motor_Dialog, "Cancel;Back;Finish", result);
                    if(result == 2) result = 3;
                    break;
			}

			if (result == 0)
			{
				break;
			}

			else if(result == 1)
			{
				state--;
			}

			else if(result == 2)
			{
				state++;
			}

			else
			{
				state = 3;
			}

			if (state > 2 )
			{
				P0693 = 0x0100;
				WriteCommand(WRITE_P0693);
				WriteCommand(WRITE_P0201);
				WriteCommand(WRITE_P0296);
				WriteCommand(WRITE_P0298);
				WriteCommand(WRITE_P0400);
				WriteCommand(WRITE_P0401);
				WriteCommand(WRITE_P0403);
				WriteCommand(WRITE_P0402);
				WriteCommand(WRITE_P0404);
				WriteCommand(WRITE_P0406);
				P0693 = 0x0000;
				WriteCommand(WRITE_P0693);
				break;
			}
		}
	}
}

MENU QS_Drive_Dialog
{
	LABEL [Inverter_Data];
	STYLE DIALOG;
	ACCESS OFFLINE;
	ITEMS
	{
		P0201,
		P0296,
		P0298
	}
}

MENU QS_Motor_Dialog
{
	LABEL [Motor_Data];
	STYLE DIALOG;
	ACCESS OFFLINE;
	ITEMS
	{
		P0400,
		P0401,
		P0403,
		P0402,
		P0404,
		P0406
	}
}











